/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.util;

import net.caitie.roamers.entity.PlayerLike;
import net.caitie.roamers.util.BuilderData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;

public class BuilderManager {
    protected PlayerLike builder;
    protected BuilderData builderData;
    private Block buildingBlock;

    public BuilderManager(PlayerLike builder) {
        this.builder = builder;
        this.builderData = new BuilderData();
    }

    public void tick() {
        this.builderData.update();
    }

    public Block getBuildingBlock() {
        return this.buildingBlock;
    }

    public void setBuildingBlock(Block block) {
        this.buildingBlock = block;
    }

    public BuilderData getBuilderData() {
        return this.builderData;
    }

    public PlayerLike getBuilder() {
        return this.builder;
    }

    public void setWantedStructure(String structure) {
        this.builderData.setStructureLocation(structure);
    }

    public String getStructureLocation() {
        return this.builderData.structureLoc;
    }

    public CompoundTag saveBuilderData() {
        return this.builderData.save();
    }

    public void getOrCreateData(CompoundTag tag) {
        this.builderData = this.builderData.loadOrCreate(this.builder, tag);
    }
}

