/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfigListener;
import io.github.lgatodu47.screenshot_viewer.screens.EnlargedScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotList;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotPropertiesMenu;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotWidget;
import java.io.File;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ManageScreenshotsScreen
extends Screen
implements ScreenshotViewerConfigListener {
    static final ScreenshotViewerConfig CONFIG = ScreenshotViewer.getInstance().getConfig();
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation CONFIG_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/config_button.png");
    private static final ResourceLocation REFRESH_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/refresh_button.png");
    private static final ResourceLocation ASCENDING_ORDER_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/ascending_order_button.png");
    private static final ResourceLocation DESCENDING_ORDER_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/descending_order_button.png");
    private static final ResourceLocation OPEN_FOLDER_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/open_folder_button.png");
    private final Screen parent;
    private final EnlargedScreenshotScreen enlargedScreenshot;
    private final ScreenshotPropertiesMenu screenshotProperties;
    private ScreenshotList list;
    private float screenshotScaleAnimation;
    private boolean isCtrlDown;

    public ManageScreenshotsScreen(Screen parent) {
        super(ScreenshotViewer.translatable("screen", "manage_screenshots"));
        this.parent = parent;
        this.enlargedScreenshot = new EnlargedScreenshotScreen();
        this.screenshotProperties = new ScreenshotPropertiesMenu(this::client, () -> this.f_96543_, () -> this.f_96544_);
        ScreenshotViewer.getInstance().registerConfigListener(this);
    }

    Minecraft client() {
        return this.f_96541_;
    }

    public void m_86600_() {
        if (this.screenshotProperties != null) {
            this.screenshotProperties.tick();
        }
    }

    protected void m_7856_() {
        if (this.f_96541_ == null) {
            return;
        }
        int spacing = 8;
        int btnHeight = 20;
        this.enlargedScreenshot.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        int contentWidth = this.f_96543_ - 24;
        int contentHeight = this.f_96544_ - 40 - 20;
        if (this.list == null) {
            this.list = new ScreenshotList(this, 12, 24, this.f_96543_ - 24, this.f_96544_ - 40 - 20);
            this.list.init();
        } else {
            this.list.updateSize(contentWidth, contentHeight);
            this.list.updateChildren();
        }
        this.m_7787_((GuiEventListener)this.list);
        int btnY = this.f_96544_ - 8 - 20;
        int btnSize = 20;
        int bigBtnWidth = 200;
        Optional<BiFunction<Minecraft, Screen, Screen>> configScreenFactory = ScreenshotViewer.getInstance().getConfigScreenFactory();
        ExtendedTexturedButtonWidget configButton = new ExtendedTexturedButtonWidget(2, 2, 20, 20, 0, 0, 20, CONFIG_BUTTON_TEXTURE, 32, 64, button -> configScreenFactory.ifPresent(f -> this.f_96541_.m_91152_((Screen)f.apply(this.f_96541_, this))), ScreenshotViewer.translatable("screen", configScreenFactory.isPresent() ? "button.config" : "no_config"), ScreenshotViewer.translatable("screen", configScreenFactory.isPresent() ? "button.config" : "no_config")).offsetTooltip();
        ((Button)configButton).f_93623_ = configScreenFactory.isPresent();
        this.m_142416_((GuiEventListener)configButton);
        this.m_142416_((GuiEventListener)new ExtendedTexturedButtonWidget(8, btnY, 20, 20, 0, 0, 20, null, 32, 64, button -> {
            if (this.list != null) {
                this.list.invertOrder();
            }
        }, null, ScreenshotViewer.translatable("screen", "button.order")){

            @Override
            @Nullable
            protected Component getTooltipText() {
                return ManageScreenshotsScreen.this.list == null ? null : ScreenshotViewer.translatable("screen", ManageScreenshotsScreen.this.list.isInvertedOrder() ? "button.order.descending" : "button.order.ascending");
            }

            @Override
            @Nullable
            public ResourceLocation getTexture() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? DESCENDING_ORDER_BUTTON_TEXTURE : ASCENDING_ORDER_BUTTON_TEXTURE);
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedTexturedButtonWidget(36, btnY, 20, 20, 0, 0, 20, OPEN_FOLDER_BUTTON_TEXTURE, 32, 64, btn -> Util.m_137581_().m_137644_(new File(this.f_96541_.f_91069_, "screenshots")), ScreenshotViewer.translatable("screen", "button.screenshot_folder"), ScreenshotViewer.translatable("screen", "button.screenshot_folder")));
        this.m_142416_((GuiEventListener)new ExtendedButtonWidget((this.f_96543_ - 200) / 2, btnY, 200, 20, CommonComponents.f_130655_, button -> this.m_7379_()));
        this.m_142416_((GuiEventListener)new ExtendedTexturedButtonWidget(this.f_96543_ - 8 - 20, btnY, 20, 20, 0, 0, 20, REFRESH_BUTTON_TEXTURE, 32, 64, button -> this.list.init(), ScreenshotViewer.translatable("screen", "button.refresh"), ScreenshotViewer.translatable("screen", "button.refresh")));
    }

    public void m_6574_(Minecraft client, int width, int height) {
        super.m_6574_(client, width, height);
        this.enlargedScreenshot.m_6574_(client, width, height);
        this.screenshotProperties.hide();
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        if (this.list != null) {
            this.list.render(matrices, mouseX, mouseY, delta, !this.enlargedScreenshot.renders() && !this.screenshotProperties.renders());
        }
        ManageScreenshotsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        Component text = ScreenshotViewer.translatable("screen", "screenshot_manager.zoom");
        ManageScreenshotsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)text, (int)(this.f_96543_ - this.f_96547_.m_92852_((FormattedText)text) - 8), (int)8, (int)(this.isCtrlDown ? 1629753 : 15780386));
        super.m_86412_(matrices, mouseX, mouseY, delta);
        this.screenshotProperties.m_86412_(matrices, mouseX, mouseY, delta);
        if (this.enlargedScreenshot.renders()) {
            float animationTime = 1.0f;
            if (((Boolean)ManageScreenshotsScreen.CONFIG.enableScreenshotEnlargementAnimation.get()).booleanValue() && this.screenshotScaleAnimation < 1.0f) {
                this.screenshotScaleAnimation = (float)((double)this.screenshotScaleAnimation + 0.03);
                animationTime = (float)(1.0 - Math.pow(1.0f - this.screenshotScaleAnimation, 3.0));
            }
            matrices.m_85836_();
            matrices.m_252880_(0.0f, 0.0f, 1.0f);
            this.enlargedScreenshot.m_7333_(matrices);
            matrices.m_252880_((float)this.enlargedScreenshot.f_96543_ / 2.0f * (1.0f - animationTime), (float)this.enlargedScreenshot.f_96544_ / 2.0f * (1.0f - animationTime), 0.0f);
            matrices.m_85841_(animationTime, animationTime, animationTime);
            this.enlargedScreenshot.m_86412_(matrices, mouseX, mouseY, delta);
            matrices.m_85849_();
        } else {
            if (this.screenshotScaleAnimation > 0.0f) {
                this.screenshotScaleAnimation = 0.0f;
            }
            if (!this.screenshotProperties.renders()) {
                for (GuiEventListener element : this.m_6702_()) {
                    if (!(element instanceof CustomHoverState)) continue;
                    CustomHoverState hover = (CustomHoverState)element;
                    hover.updateHoveredState(mouseX, mouseY);
                }
            }
        }
    }

    void enlargeScreenshot(ScreenshotImageHolder showing) {
        this.enlargedScreenshot.show(showing, this.list);
    }

    void showScreenshotProperties(double mouseX, double mouseY, ScreenshotWidget widget) {
        this.screenshotProperties.show((int)mouseX, (int)mouseY, () -> this.list.removeEntry(widget), widget.getScreenshotFile(), widget::updateScreenshotFile);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_7933_(keyCode, scanCode, modifiers);
        }
        this.isCtrlDown = keyCode == 341 || keyCode == 345;
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_7920_(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_7920_(keyCode, scanCode, modifiers);
        }
        if (this.isCtrlDown) {
            this.isCtrlDown = false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_5534_(chr, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_5534_(chr, modifiers);
        }
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_6050_(mouseX, mouseY, amount);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_6050_(mouseX, mouseY, amount);
        }
        if (this.list != null) {
            if (this.isCtrlDown) {
                this.list.updateScreenshotsPerRow(amount);
                return true;
            }
            return this.list.m_6050_(mouseX, mouseY, amount);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_6375_(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_6348_(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_94729_(mouseX, mouseY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_94729_(mouseX, mouseY);
        }
        return super.m_94729_(mouseX, mouseY);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
        ScreenshotViewer.getInstance().unregisterConfigListener(this);
    }

    public void m_7861_() {
        this.list.close();
    }

    @Override
    public void onConfigReloaded() {
        this.list.configUpdated();
    }

    private static class ExtendedTexturedButtonWidget
    extends ImageButton
    implements CustomHoverState {
        @Nullable
        private final ResourceLocation texture;
        private final int u;
        private final int v;
        private final int hoveredVOffset;
        private final int textureWidth;
        private final int textureHeight;
        @Nullable
        private final Component tooltip;
        private boolean offsetTooltip;

        ExtendedTexturedButtonWidget(int x, int y, int width, int height, int u, int v, int hoveredVOffset, @Nullable ResourceLocation texture, int textureWidth, int textureHeight, Button.OnPress pressAction, @Nullable Component tooltip, Component text) {
            super(x, y, width, height, u, v, hoveredVOffset, Button.f_93617_, textureWidth, textureHeight, pressAction, text);
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.u = u;
            this.v = v;
            this.hoveredVOffset = hoveredVOffset;
            this.texture = texture;
            this.tooltip = tooltip;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)tooltip));
            }
        }

        ExtendedTexturedButtonWidget offsetTooltip() {
            this.offsetTooltip = true;
            return this;
        }

        public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            if (!this.f_93624_) {
                return;
            }
            this.m_87963_(matrices, mouseX, mouseY, delta);
            this.updateTooltip();
        }

        private void updateTooltip() {
            Screen screen;
            Component tooltip = this.getTooltipText();
            if (tooltip != null && (this.f_93622_ || this.m_93696_() && Minecraft.m_91087_().m_264529_().m_264505_()) && (screen = Minecraft.m_91087_().f_91080_) != null) {
                screen.m_262791_(Tooltip.m_257550_((Component)tooltip), this.m_262860_(), this.m_93696_());
            }
        }

        @Nullable
        protected Component getTooltipText() {
            return this.tooltip;
        }

        protected ClientTooltipPositioner m_262860_() {
            return this.offsetTooltip ? (screen, x, y, w, h) -> super.m_262860_().m_262814_(screen, x, y + this.f_93619_, w, h) : super.m_262860_();
        }

        @Nullable
        public ResourceLocation getTexture() {
            return this.texture;
        }

        public void m_87963_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            ResourceLocation texture = this.getTexture();
            if (texture == null) {
                GuiComponent.m_93172_((PoseStack)matrices, (int)this.m_252754_(), (int)this.m_252907_(), (int)(this.m_252754_() + this.f_93618_), (int)(this.m_252907_() + this.f_93619_), (int)0xFFFFFF);
            } else {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
                int vOffset = this.v;
                if (!this.m_142518_()) {
                    vOffset += this.hoveredVOffset * 2;
                } else if (this.m_198029_()) {
                    vOffset += this.hoveredVOffset;
                }
                RenderSystem.m_69482_();
                GuiComponent.m_93133_((PoseStack)matrices, (int)this.m_252754_(), (int)this.m_252907_(), (float)this.u, (float)vOffset, (int)this.f_93618_, (int)this.f_93619_, (int)this.textureWidth, (int)this.textureHeight);
            }
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
        }
    }

    private static final class ExtendedButtonWidget
    extends Button
    implements CustomHoverState {
        ExtendedButtonWidget(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, Supplier::get);
        }

        public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            if (!this.f_93624_) {
                return;
            }
            super.m_87963_(matrices, mouseX, mouseY, delta);
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
        }
    }

    private static interface CustomHoverState {
        public void updateHoveredState(int var1, int var2);
    }
}

