/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mindoth.skillcloaks.client.renderer.CurioRenderer;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CloakRenderer
implements CurioRenderer {
    private final ResourceLocation texture;
    private final BipedModel<LivingEntity> model;

    public CloakRenderer(String texturePath, BipedModel<LivingEntity> model) {
        this(new ResourceLocation("skillcloaks", String.format("textures/entity/curio/%s.png", texturePath)), model);
    }

    public CloakRenderer(ResourceLocation texture, BipedModel<LivingEntity> model) {
        this.texture = texture;
        this.model = model;
    }

    protected ResourceLocation getTexture() {
        return this.texture;
    }

    protected BipedModel<LivingEntity> getModel() {
        return this.model;
    }

    @Override
    public final void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ticks, float headYaw, float headPitch, ItemStack stack) {
        BipedModel<LivingEntity> model = this.getModel();
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && entity.func_82150_aj() && (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.THIEVING_CLOAK.get(), entity).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), entity).isPresent())) {
            return;
        }
        if (ModList.get().isLoaded("caelus")) {
            if (!CaelusApi.canElytraFly((LivingEntity)entity)) {
                model.func_225597_a_(entity, limbSwing, limbSwingAmount, ticks, headYaw, headPitch);
                model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
                ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
                if (EnchantmentHelper.func_82781_a((ItemStack)entity.func_184582_a(EquipmentSlotType.CHEST)).isEmpty()) {
                    this.render(matrixStack, buffer, light, stack.func_77962_s());
                } else {
                    this.render(matrixStack, buffer, light, true);
                }
            }
        } else if (!(entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ElytraItem)) {
            model.func_225597_a_(entity, limbSwing, limbSwingAmount, ticks, headYaw, headPitch);
            model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
            ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
            if (EnchantmentHelper.func_82781_a((ItemStack)entity.func_184582_a(EquipmentSlotType.CHEST)).isEmpty()) {
                this.render(matrixStack, buffer, light, stack.func_77962_s());
            } else {
                this.render(matrixStack, buffer, light, true);
            }
        }
    }

    protected void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, boolean hasFoil) {
        RenderType renderType = this.model.func_228282_a_(this.getTexture());
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        this.model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

