/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.network.message.DoubleJumpPacket;
import net.mindoth.skillcloaks.network.message.SkillcloaksNetwork;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class AgilityCloakItem
extends CurioItem {
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.agility_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("curios.modifiers.cloak").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("+" + ((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).toString() + " ").func_240699_a_(TextFormatting.BLUE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.armor_value")));
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    @Override
    public boolean isEquippedBy(@Nullable LivingEntity entity) {
        return CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, entity).isPresent();
    }

    protected <T extends Event, S extends LivingEntity> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        MinecraftForge.EVENT_BUS.addListener(priority, true, eventClass, event -> {
            LivingEntity wearer = (LivingEntity)wearerSupplier.apply(event);
            if (this.isEquippedBy(wearer)) {
                listener.accept(event, wearer);
            }
        });
    }

    protected <T extends Event, S extends LivingEntity> void addListener(Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        this.addListener(EventPriority.NORMAL, eventClass, listener, wearerSupplier);
    }

    protected <T extends LivingEvent> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(priority, eventClass, listener, LivingEvent::getEntityLiving);
    }

    protected <T extends LivingEvent> void addListener(Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(EventPriority.NORMAL, eventClass, listener);
    }

    public AgilityCloakItem() {
        MinecraftForge.EVENT_BUS.register((Object)new DoubleJumpHandler());
        this.addListener(EventPriority.HIGHEST, LivingFallEvent.class, this::onLivingFall);
    }

    @Override
    public void jump(PlayerEntity player) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        player.field_70143_R = 0.0f;
        double upwardsMotion = 0.5;
        Vector3d motion = player.func_213322_ci();
        double motionMultiplier = 0.0;
        float direction = (float)((double)player.field_70177_z * Math.PI / 180.0);
        player.func_213317_d(player.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)direction)) * motionMultiplier, upwardsMotion - motion.field_72448_b, (double)MathHelper.func_76134_b((float)direction) * motionMultiplier));
        player.field_70160_al = true;
        ForgeHooks.onLivingJump((LivingEntity)player);
        player.func_195066_a(Stats.field_75953_u);
        player.func_71020_j(0.05f);
        player.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 1.0f);
    }

    private void onLivingFall(LivingFallEvent event, LivingEntity wearer) {
        event.setDistance(Math.max(0.0f, event.getDistance() - 3.0f));
    }

    private class DoubleJumpHandler {
        @OnlyIn(value=Dist.CLIENT)
        private boolean canDoubleJump;
        @OnlyIn(value=Dist.CLIENT)
        private boolean hasReleasedJumpKey;

        private DoubleJumpHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
                return;
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (event.phase == TickEvent.Phase.END && player != null && player.field_71158_b != null) {
                if ((player.func_233570_aj_() || player.func_70617_f_()) && !player.func_70090_H()) {
                    this.hasReleasedJumpKey = false;
                    this.canDoubleJump = true;
                } else if (!player.field_71158_b.field_78901_c) {
                    this.hasReleasedJumpKey = true;
                } else if (!player.field_71075_bZ.field_75100_b && this.canDoubleJump && this.hasReleasedJumpKey) {
                    this.canDoubleJump = false;
                    if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.AGILITY_CLOAK.get(), (LivingEntity)player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent()) {
                        SkillcloaksNetwork.CHANNEL.sendToServer((Object)new DoubleJumpPacket());
                        AgilityCloakItem.this.jump((PlayerEntity)player);
                    }
                }
            }
        }
    }
}

