/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class CookingCloakItem
extends CurioItem {
    public static final UUID MINDOTH_UUID = UUID.fromString("3e2da4bc-fb81-4750-a5d5-dd34e3d28b0f");

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.cooking_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("curios.modifiers.cloak").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("+" + ((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).toString() + " ").func_240699_a_(TextFormatting.BLUE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.armor_value")));
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    private static CampfireCookingRecipe getCampfireCookingRecipe(PlayerEntity player, IInventory inv) {
        return player.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222153_e, inv, player.field_70170_p).orElse(null);
    }

    @SubscribeEvent
    public static void onPlayerUseCookingBlock(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.COOKING_CLOAK.get(), (LivingEntity)player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent()) {
            ItemStack mainHandItemStack = player.func_184614_ca();
            ItemStack offHandItemStack = player.func_184592_cb();
            Inventory slotInv = new Inventory(new ItemStack[]{mainHandItemStack});
            Inventory slotInvOff = new Inventory(new ItemStack[]{offHandItemStack});
            CampfireCookingRecipe recipe = CookingCloakItem.getCampfireCookingRecipe(player, (IInventory)slotInv);
            CampfireCookingRecipe recipeOff = CookingCloakItem.getCampfireCookingRecipe(player, (IInventory)slotInvOff);
            if ((recipe != null || recipeOff != null) && (mainHandItemStack.func_77973_b() instanceof FlintAndSteelItem || offHandItemStack.func_77973_b() instanceof FlintAndSteelItem)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUseCooking(PlayerInteractEvent.RightClickItem event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.COOKING_CLOAK.get(), (LivingEntity)player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent()) {
            ItemStack mainHandItemStack = player.func_184614_ca();
            ItemStack offHandItemStack = player.func_184592_cb();
            Inventory slotInv = new Inventory(new ItemStack[]{mainHandItemStack});
            Inventory slotInvOff = new Inventory(new ItemStack[]{offHandItemStack});
            CampfireCookingRecipe recipe = CookingCloakItem.getCampfireCookingRecipe(player, (IInventory)slotInv);
            CampfireCookingRecipe recipeOff = CookingCloakItem.getCampfireCookingRecipe(player, (IInventory)slotInvOff);
            if ((recipe != null || recipeOff != null) && (mainHandItemStack.func_77973_b() instanceof FlintAndSteelItem || offHandItemStack.func_77973_b() instanceof FlintAndSteelItem)) {
                event.setCanceled(true);
                if (offHandItemStack.func_77973_b() instanceof FlintAndSteelItem) {
                    int size = mainHandItemStack.func_190916_E();
                    for (int i = 0; i < size; ++i) {
                        ItemStack result;
                        if (!(offHandItemStack.func_77973_b() instanceof FlintAndSteelItem) || offHandItemStack.func_77952_i() > offHandItemStack.func_77958_k() || (result = recipe.func_77572_b((IInventory)slotInv)).func_190926_b()) continue;
                        mainHandItemStack.func_190918_g(1);
                        ItemEntity drop = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), result);
                        drop.func_213293_j(0.0, 0.0, 0.0);
                        drop.func_174868_q();
                        player.field_70170_p.func_217376_c((Entity)drop);
                        offHandItemStack.func_222118_a(1, (LivingEntity)player, holder -> holder.func_213361_c(EquipmentSlotType.OFFHAND));
                    }
                    if (Objects.equals(player.func_110124_au(), MINDOTH_UUID)) {
                        if (!world.field_72995_K) {
                            int i;
                            ServerWorld level = (ServerWorld)world;
                            for (i = 0; i < 8; ++i) {
                                level.func_195598_a((IParticleData)ParticleTypes.field_218417_ae, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 1, 0.0, 0.0, 0.0, (double)0.1f);
                            }
                            for (i = 0; i < 4; ++i) {
                                level.func_195598_a((IParticleData)ParticleTypes.field_197631_x, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 1, 0.0, 0.0, 0.0, (double)0.1f);
                            }
                        }
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187616_bj, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    } else {
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                } else if (mainHandItemStack.func_77973_b() instanceof FlintAndSteelItem) {
                    int size = offHandItemStack.func_190916_E();
                    for (int i = 0; i < size; ++i) {
                        ItemStack result;
                        if (!(mainHandItemStack.func_77973_b() instanceof FlintAndSteelItem) || mainHandItemStack.func_77952_i() > mainHandItemStack.func_77958_k() || (result = recipeOff.func_77572_b((IInventory)slotInv)).func_190926_b()) continue;
                        offHandItemStack.func_190918_g(1);
                        ItemEntity drop = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), result);
                        drop.func_213293_j(0.0, 0.0, 0.0);
                        drop.func_174868_q();
                        player.field_70170_p.func_217376_c((Entity)drop);
                        mainHandItemStack.func_222118_a(1, (LivingEntity)player, holder -> holder.func_213361_c(EquipmentSlotType.MAINHAND));
                    }
                    if (Objects.equals(player.func_110124_au(), MINDOTH_UUID)) {
                        if (!world.field_72995_K) {
                            int i;
                            ServerWorld level = (ServerWorld)world;
                            for (i = 0; i < 8; ++i) {
                                level.func_195598_a((IParticleData)ParticleTypes.field_218417_ae, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 1, 0.0, 0.0, 0.0, (double)0.1f);
                            }
                            for (i = 0; i < 4; ++i) {
                                level.func_195598_a((IParticleData)ParticleTypes.field_197631_x, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 1, 0.0, 0.0, 0.0, (double)0.1f);
                            }
                        }
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187616_bj, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    } else {
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

