/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class DefenceCloakItem
extends CurioItem {
    private static final String TAG_DEFENCE_COOLDOWN = "preventDeath";

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.defence_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("curios.modifiers.cloak").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("+" + ((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).toString() + " ").func_240699_a_(TextFormatting.BLUE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.armor_value")));
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    @SubscribeEvent
    public static void onDamageEvent(LivingDamageEvent event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            LivingEntity player = event.getEntityLiving();
            CompoundNBT playerData = player.getPersistentData();
            CompoundNBT data = playerData.func_74775_l("PlayerPersisted");
            if (event.getAmount() >= event.getEntityLiving().func_110143_aJ() && (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.DEFENCE_CLOAK.get(), player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), player).isPresent()) && data.func_74762_e(TAG_DEFENCE_COOLDOWN) <= 0) {
                event.setAmount(0.0f);
                player.func_70606_j(1.0f);
                player.func_195061_cb();
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76426_n, 800, 0));
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_191263_gW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                data.func_74768_a(TAG_DEFENCE_COOLDOWN, 24000);
                playerData.func_218657_a("PlayerPersisted", (INBT)data);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = playerData.func_74775_l("PlayerPersisted");
        if (!player.field_70170_p.field_72995_K) {
            if (player.field_70173_aa % 2 == 0 && data.func_74762_e(TAG_DEFENCE_COOLDOWN) > 0) {
                data.func_74768_a(TAG_DEFENCE_COOLDOWN, data.func_74762_e(TAG_DEFENCE_COOLDOWN) - 1);
                playerData.func_218657_a("PlayerPersisted", (INBT)data);
            }
            if (data.func_74762_e(TAG_DEFENCE_COOLDOWN) == 1) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.defence.recharged"), true);
                player.func_213823_a(SoundEvents.field_187941_ho, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (data.func_74762_e(TAG_DEFENCE_COOLDOWN) <= 0) {
                data.func_82580_o(TAG_DEFENCE_COOLDOWN);
            }
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.getWearer();
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            CompoundNBT playerData = player.getPersistentData();
            CompoundNBT data = playerData.func_74775_l("PlayerPersisted");
            if (!player.field_70170_p.field_72995_K && data.func_74762_e(TAG_DEFENCE_COOLDOWN) > 0) {
                int totalSecs = data.func_74762_e(TAG_DEFENCE_COOLDOWN) / 20;
                int mins = totalSecs % 3600 / 60;
                int secs = totalSecs % 60;
                if (mins > 0) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.defence.cooldown").func_230529_a_((ITextComponent)new TranslationTextComponent(mins + "m " + secs + "s")), true);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.defence.cooldown").func_230529_a_((ITextComponent)new TranslationTextComponent(secs + "s")), true);
                }
                player.func_213823_a(SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 1.0f, 0.5f);
            }
        }
    }
}

