/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class FarmingCloakItem
extends CurioItem {
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.farming_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("curios.modifiers.cloak").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("+" + ((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).toString() + " ").func_240699_a_(TextFormatting.BLUE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.armor_value")));
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    @SubscribeEvent
    public static void onPlayerUseFarming(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        World level = event.getWorld();
        BlockPos pos = event.getPos();
        if ((CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.FARMING_CLOAK.get(), (LivingEntity)player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent()) && event.getItemStack().func_77973_b().equals(Items.field_196106_bc)) {
            if (pos == player.getEntity().func_233580_cy_() || level.func_180495_p(pos).func_177230_c() instanceof IGrowable) {
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
            }
            BlockPos.Mutable mutableblockpos = new BlockPos.Mutable();
            int xRange = (Integer)SkillcloaksCommonConfig.FARMING_RANGE.get();
            int zRange = (Integer)SkillcloaksCommonConfig.FARMING_RANGE.get();
            for (int xPos = pos.func_177958_n() - xRange; xPos <= pos.func_177958_n() + xRange; ++xPos) {
                for (int zPos = pos.func_177952_p() - zRange; zPos <= pos.func_177952_p() + zRange; ++zPos) {
                    BlockPos.Mutable position = mutableblockpos.func_181079_c(xPos, pos.func_177956_o(), zPos);
                    Block block = level.func_180495_p((BlockPos)position).func_177230_c();
                    if (!(block instanceof IGrowable)) continue;
                    BoneMealItem.applyBonemeal((ItemStack)new ItemStack((IItemProvider)Items.field_196106_bc), (World)level, (BlockPos)position, (PlayerEntity)player);
                    if (level.field_72995_K) continue;
                    FarmingCloakItem.addGrowthParticles((ServerWorld)level, (BlockPos)position, (ServerPlayerEntity)player);
                }
            }
            if (!player.func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
        }
    }

    private static void addGrowthParticles(ServerWorld level, BlockPos pos, ServerPlayerEntity player) {
        Random random = new Random();
        int numParticles = 2;
        BlockState blockstate = level.func_180495_p(pos);
        if (!blockstate.isAir((IBlockReader)level, pos)) {
            double d1;
            double d0 = 0.5;
            if (blockstate.func_203425_a(Blocks.field_150355_j)) {
                numParticles *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.func_200015_d((IBlockReader)level, pos)) {
                pos = pos.func_177984_a();
                numParticles *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = 1.0;
            }
            level.func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, numParticles, 0.0, 0.0, 0.5, 0.5);
            for (int i = 0; i < numParticles; ++i) {
                double z;
                double y;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                double d4 = random.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double x = (double)pos.func_177958_n() + d5 + random.nextDouble() * d0 * 2.0;
                if (level.func_180495_p(new BlockPos(x, y = (double)pos.func_177956_o() + random.nextDouble() * d1, z = (double)pos.func_177952_p() + d5 + random.nextDouble() * d0 * 2.0).func_177977_b()).func_196958_f()) continue;
                level.func_195598_a((IParticleData)ParticleTypes.field_197632_y, x, y, z, numParticles, d2, d3, d4, 0.5);
            }
        }
    }
}

