/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class PrayerCloakItem
extends CurioItem {
    private static final String TAG_HAS_PRAYER_CLOAK = "saveXp";

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.prayer_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("curios.modifiers.cloak").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("+" + ((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).toString() + " ").func_240699_a_(TextFormatting.BLUE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.armor_value")));
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    public ICurio.DropRule getDropRule(LivingEntity livingEntity, ItemStack stack) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return ICurio.DropRule.DEFAULT;
        }
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    @SubscribeEvent
    public static void onPlayerXpDrop(LivingExperienceDropEvent event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.PRAYER_CLOAK.get(), (LivingEntity)player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLethal(LivingDamageEvent event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        LivingEntity player = event.getEntityLiving();
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = playerData.func_74775_l("PlayerPersisted");
        if (event.getAmount() >= player.func_110143_aJ() && (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.PRAYER_CLOAK.get(), player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), player).isPresent()) && !data.func_74767_n(TAG_HAS_PRAYER_CLOAK)) {
            data.func_74757_a(TAG_HAS_PRAYER_CLOAK, true);
            playerData.func_218657_a("PlayerPersisted", (INBT)data);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        CompoundNBT playerData;
        CompoundNBT data;
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        if (event.isWasDeath() && (data = (playerData = event.getOriginal().getPersistentData()).func_74775_l("PlayerPersisted")).func_74767_n(TAG_HAS_PRAYER_CLOAK) && event.getPlayer().field_71067_cb <= 0) {
            event.getPlayer().func_195068_e(event.getOriginal().field_71067_cb);
            data.func_82580_o(TAG_HAS_PRAYER_CLOAK);
        }
    }
}

