/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class WoodcuttingCloakItem
extends CurioItem {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.field_208515_s;

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.woodcutting_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("curios.modifiers.cloak").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("+" + ((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).toString() + " ").func_240699_a_(TextFormatting.BLUE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.skillcloaks.armor_value")));
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    private static List<BlockPos> getLogsToBreak(World world, BlockPos pos, List<BlockPos> logsToBreak) {
        ArrayList<Object> checkAround = new ArrayList<Object>();
        Iterator aroundLogs = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)(pos.func_177956_o() + 1), (int)(pos.func_177952_p() + 1)).iterator();
        while (aroundLogs.hasNext()) {
            BlockPos logPos = ((BlockPos)aroundLogs.next()).func_185334_h();
            if (logsToBreak.contains(logPos) || !world.func_180495_p(logPos).func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h)) continue;
            checkAround.add(logPos);
            logsToBreak.add(logPos);
        }
        if (checkAround.size() == 0) {
            return logsToBreak;
        }
        for (BlockPos blockPos : checkAround) {
            for (BlockPos logPos : WoodcuttingCloakItem.getLogsToBreak(world, blockPos, logsToBreak)) {
                if (logsToBreak.contains(logPos)) continue;
                logsToBreak.add(logPos.func_185334_h());
            }
        }
        BlockPos up = pos.func_177981_b(2);
        return WoodcuttingCloakItem.getLogsToBreak(world, up.func_185334_h(), logsToBreak);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        World world = event.getPlayer().field_70170_p;
        if (!world.field_72995_K && (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.WOODCUTTING_CLOAK.get(), (LivingEntity)event.getPlayer()).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)event.getPlayer()).isPresent()) && !event.getPlayer().func_213453_ef() && event.getState().func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h)) {
            List<BlockPos> logs = WoodcuttingCloakItem.getLogsToBreak(world, event.getPos(), new ArrayList<BlockPos>());
            ItemStack axeItem = event.getPlayer().func_184582_a(EquipmentSlotType.MAINHAND);
            int durability = axeItem.func_77958_k() - axeItem.func_77952_i();
            if (axeItem.func_77973_b() instanceof AxeItem && durability >= logs.size()) {
                boolean isTree = false;
                for (BlockPos leafPos : logs) {
                    Stream aroundLogs = BlockPos.func_218287_a((int)(leafPos.func_177958_n() - 1), (int)(leafPos.func_177956_o() - 1), (int)(leafPos.func_177952_p() - 1), (int)(leafPos.func_177958_n() + 1), (int)(leafPos.func_177956_o() + 1), (int)(leafPos.func_177952_p() + 1));
                    if (!aroundLogs.anyMatch(t -> world.func_180495_p((BlockPos)new BlockPos.Mutable(t.func_177958_n(), t.func_177956_o(), t.func_177952_p())).func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E) && world.func_180495_p((BlockPos)new BlockPos.Mutable(t.func_177958_n(), t.func_177956_o(), t.func_177952_p())).func_235901_b_((Property)PERSISTENT) && (Boolean)world.func_180495_p((BlockPos)new BlockPos.Mutable(t.func_177958_n(), t.func_177956_o(), t.func_177952_p())).func_177229_b((Property)PERSISTENT) == false)) continue;
                    isTree = true;
                }
                if (isTree) {
                    for (BlockPos logPos : logs) {
                        world.func_180495_p(logPos).func_177230_c().func_180657_a(world, event.getPlayer(), logPos, world.func_180495_p(logPos), null, axeItem);
                        world.func_217377_a(logPos, false);
                        axeItem.func_222118_a(1, (LivingEntity)event.getPlayer(), holder -> holder.func_213361_c(EquipmentSlotType.MAINHAND));
                    }
                }
            } else {
                world.func_184148_a(null, event.getPlayer().func_226277_ct_(), event.getPlayer().func_226278_cu_() + 1.0, event.getPlayer().func_226281_cx_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 0.5f);
            }
        }
    }
}

