/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.network.message;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.mindoth.skillcloaks.client.gui.InventoryCraftingContainer;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RespawnAnchorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class CloakAbilityPacket {
    public static final UUID UNION_UUID = UUID.fromString("e8ef4b7d-f91a-4a40-b020-c44386355641");
    private static final String TAG_MAX_MODE = "skillcloak.mode";
    public int key;
    private static final ITextComponent CONTAINER_TITLE = new TranslationTextComponent("container.crafting");

    public CloakAbilityPacket() {
    }

    public CloakAbilityPacket(int key) {
        this.key = key;
    }

    public static void encode(CloakAbilityPacket message, PacketBuffer buffer) {
        buffer.writeInt(message.key);
    }

    public static CloakAbilityPacket decode(PacketBuffer buffer) {
        return new CloakAbilityPacket(buffer.readInt());
    }

    public static INamedContainerProvider getMenuProvider(World p_220052_2_, BlockPos p_220052_3_) {
        return new SimpleNamedContainerProvider((p_220270_2_, p_220270_3_, p_220270_4_) -> new InventoryCraftingContainer(p_220270_2_, p_220270_3_, IWorldPosCallable.func_221488_a((World)p_220052_2_, (BlockPos)p_220052_3_)), CONTAINER_TITLE);
    }

    public static void handle(CloakAbilityPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            ServerWorld world = player.func_71121_q();
            CompoundNBT playerMaxData = player.getPersistentData();
            CompoundNBT maxData = playerMaxData.func_74775_l("PlayerPersisted");
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent() && !player.func_184811_cZ().func_185141_a((Item)SkillcloaksItems.MAX_CLOAK.get()) && player.func_213453_ef()) {
                switch (maxData.func_74762_e(TAG_MAX_MODE)) {
                    case 1: {
                        maxData.func_74768_a(TAG_MAX_MODE, 2);
                        playerMaxData.func_218657_a("PlayerPersisted", (INBT)maxData);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.max.mode.construction"), true);
                        player.func_184811_cZ().func_185145_a((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    case 2: {
                        if (ModList.get().isLoaded("lucent")) {
                            maxData.func_74768_a(TAG_MAX_MODE, 1);
                        } else {
                            maxData.func_74768_a(TAG_MAX_MODE, 3);
                        }
                        playerMaxData.func_218657_a("PlayerPersisted", (INBT)maxData);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.max.mode.crafting"), true);
                        player.func_184811_cZ().func_185145_a((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    case 3: {
                        maxData.func_74768_a(TAG_MAX_MODE, 1);
                        playerMaxData.func_218657_a("PlayerPersisted", (INBT)maxData);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.max.mode.firemaking"), true);
                        player.func_184811_cZ().func_185145_a((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    default: {
                        maxData.func_74768_a(TAG_MAX_MODE, 2);
                        playerMaxData.func_218657_a("PlayerPersisted", (INBT)maxData);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.max.mode.construction"), true);
                        player.func_184811_cZ().func_185145_a((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                    }
                }
            }
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.CRAFTING_CLOAK.get(), (LivingEntity)player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent() && !player.func_213453_ef()) {
                if (!ModList.get().isLoaded("lucent")) {
                    if (maxData.func_74762_e(TAG_MAX_MODE) == 3 || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.CRAFTING_CLOAK.get(), (LivingEntity)player).isPresent()) {
                        player.func_213829_a(CloakAbilityPacket.getMenuProvider(player.field_70170_p, player.func_233580_cy_()));
                    }
                } else if (maxData.func_74762_e(TAG_MAX_MODE) == 1 || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.CRAFTING_CLOAK.get(), (LivingEntity)player).isPresent()) {
                    player.func_213829_a(CloakAbilityPacket.getMenuProvider(player.field_70170_p, player.func_233580_cy_()));
                }
            }
            if ((CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.CONSTRUCTION_CLOAK.get(), (LivingEntity)player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent() && maxData.func_74762_e(TAG_MAX_MODE) == 2 && !player.func_213453_ef()) && !player.func_184811_cZ().func_185141_a((Item)SkillcloaksItems.CONSTRUCTION_CLOAK.get()) && !player.func_184811_cZ().func_185141_a((Item)SkillcloaksItems.MAX_CLOAK.get())) {
                ServerWorld respawnWorld = player.field_71133_b.func_71218_a(player.func_241141_L_());
                BlockPos spawn = player.func_241140_K_();
                if (spawn != null && respawnWorld != null) {
                    BlockState blockstate = respawnWorld.func_180495_p(spawn);
                    if (respawnWorld == world) {
                        if (blockstate.func_203425_a(Blocks.field_235400_nj_) && (Integer)blockstate.func_177229_b((Property)RespawnAnchorBlock.field_235559_a_) > 0 && RespawnAnchorBlock.func_235562_a_((World)respawnWorld) || blockstate.func_235714_a_((ITag)BlockTags.field_219747_F)) {
                            player.func_225653_b_((double)spawn.func_177958_n() + 0.5, (double)(spawn.func_177956_o() + 1), (double)spawn.func_177952_p() + 0.5);
                            if (blockstate.func_203425_a(Blocks.field_235400_nj_)) {
                                respawnWorld.func_180501_a(spawn, (BlockState)blockstate.func_206870_a((Property)RespawnAnchorBlock.field_235559_a_, (Comparable)Integer.valueOf((Integer)blockstate.func_177229_b((Property)RespawnAnchorBlock.field_235559_a_) - 1)), 3);
                            }
                            if (Objects.equals(player.func_110124_au(), UNION_UUID)) {
                                world.func_184148_a(null, (double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 1.5, (double)spawn.func_177952_p() + 0.5, SoundEvents.field_187606_E, SoundCategory.PLAYERS, 1.0f, 0.5f);
                                for (int i = 0; i < 360; ++i) {
                                    if (i % 20 != 0) continue;
                                    respawnWorld.func_195598_a((IParticleData)ParticleTypes.field_197631_x, (double)spawn.func_177958_n() + 0.5 + Math.cos(i) * 1.5, (double)spawn.func_177956_o() + 1.5, (double)spawn.func_177952_p() + 0.5 + Math.sin(i) * 1.5, 1, 0.0, 0.0, 0.0, 0.0);
                                }
                            } else {
                                world.func_184148_a(null, (double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 1.5, (double)spawn.func_177952_p() + 0.5, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                                for (int i = 0; i < 10; ++i) {
                                    respawnWorld.func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)spawn.func_177958_n() + 0.5, (double)(spawn.func_177956_o() + 1), (double)spawn.func_177952_p() + 0.5, (int)(player.func_70681_au().nextDouble() * 10.0), (player.func_70681_au().nextDouble() - 0.5) * 1.5, -player.func_70681_au().nextDouble() + 1.0, (player.func_70681_au().nextDouble() - 0.5) * 1.5, 0.0);
                                }
                            }
                        } else {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.construction.cantfind"), true);
                            player.func_213823_a(SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 1.0f, 0.5f);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.construction.wrongdim"), true);
                        player.func_213823_a(SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 1.0f, 0.5f);
                    }
                    player.func_184811_cZ().func_185145_a((Item)SkillcloaksItems.CONSTRUCTION_CLOAK.get(), 20);
                    player.func_184811_cZ().func_185145_a((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.skillcloaks.construction.cantfind"), true);
                    player.func_213823_a(SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 1.0f, 0.5f);
                }
            }
            if (!ModList.get().isLoaded("lucent") && (CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.FIREMAKING_CLOAK.get(), (LivingEntity)player).isPresent() || CuriosApi.getCuriosHelper().findEquippedCurio((Item)SkillcloaksItems.MAX_CLOAK.get(), (LivingEntity)player).isPresent() && maxData.func_74762_e(TAG_MAX_MODE) == 1 && !player.func_213453_ef()) && !player.func_184811_cZ().func_185141_a((Item)SkillcloaksItems.FIREMAKING_CLOAK.get()) && !player.func_184811_cZ().func_185141_a((Item)SkillcloaksItems.MAX_CLOAK.get())) {
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                ItemEntity drop = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), new ItemStack((IItemProvider)Items.field_221657_bQ));
                drop.func_213293_j(0.0, 0.0, 0.0);
                drop.func_174868_q();
                player.field_70170_p.func_217376_c((Entity)drop);
                player.func_184811_cZ().func_185145_a((Item)SkillcloaksItems.FIREMAKING_CLOAK.get(), 20);
                player.func_184811_cZ().func_185145_a((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
            }
        });
        context.setPacketHandled(true);
    }
}

