/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.network.message.DoubleJumpPacket;
import net.mindoth.skillcloaks.network.message.SkillcloaksNetwork;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class AgilityCloakItem
extends CurioItem {
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skillcloaks.agility_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"curios.modifiers.cloak").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("+" + ((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).toString() + " ")).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)"tooltip.skillcloaks.armor_value")));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    protected <T extends LivingEvent> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(priority, eventClass, listener, LivingEvent::getEntity);
    }

    protected <T extends Event, S extends LivingEntity> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        MinecraftForge.EVENT_BUS.addListener(priority, true, eventClass, event -> {
            LivingEntity wearer = (LivingEntity)wearerSupplier.apply(event);
            if (this.isEquippedBy(wearer)) {
                listener.accept(event, wearer);
            }
        });
    }

    public AgilityCloakItem() {
        MinecraftForge.EVENT_BUS.register((Object)new DoubleJumpHandler());
        this.addListener(EventPriority.HIGHEST, LivingFallEvent.class, this::onLivingFall);
    }

    @Override
    public void jump(Player player) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        player.f_19789_ = 0.0f;
        double upwardsMotion = 0.5;
        Vec3 motion = player.m_20184_();
        double motionMultiplier = 0.0;
        float direction = (float)((double)player.m_146908_() * Math.PI / 180.0);
        player.m_20256_(player.m_20184_().m_82520_((double)(-Mth.m_14031_((float)direction)) * motionMultiplier, upwardsMotion - motion.f_82480_, (double)Mth.m_14089_((float)direction) * motionMultiplier));
        player.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)player);
        player.m_36220_(Stats.f_12926_);
        player.m_36399_(0.05f);
        player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
    }

    private void onLivingFall(LivingFallEvent event, LivingEntity wearer) {
        event.setDistance(Math.max(0.0f, event.getDistance() - 3.0f));
    }

    private class DoubleJumpHandler {
        @OnlyIn(value=Dist.CLIENT)
        private boolean canDoubleJump;
        @OnlyIn(value=Dist.CLIENT)
        private boolean hasReleasedJumpKey;

        private DoubleJumpHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (event.phase == TickEvent.Phase.END && player != null && player.f_108618_ != null) {
                if ((player.m_20096_() || player.m_6147_()) && !player.m_20069_()) {
                    this.hasReleasedJumpKey = false;
                    this.canDoubleJump = true;
                } else if (!player.f_108618_.f_108572_) {
                    this.hasReleasedJumpKey = true;
                } else if (!player.m_150110_().f_35935_ && this.canDoubleJump && this.hasReleasedJumpKey) {
                    this.canDoubleJump = false;
                    if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.AGILITY_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent()) {
                        SkillcloaksNetwork.CHANNEL.sendToServer((Object)new DoubleJumpPacket());
                        AgilityCloakItem.this.jump((Player)player);
                    }
                }
            }
        }
    }
}

