/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class MaxCloakItem
extends CurioItem {
    private static final String TAG_DEFENCE_COOLDOWN = "preventDeath";

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skillcloaks.max_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"curios.modifiers.cloak").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("+" + ((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).toString() + " ")).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)"tooltip.skillcloaks.armor_value")));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return 0;
        }
        return 1;
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return ICurio.DropRule.DEFAULT;
        }
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.getWearer();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            CompoundTag data = playerData.m_128469_("PlayerPersisted");
            if (!player.f_19853_.f_46443_ && data.m_128451_(TAG_DEFENCE_COOLDOWN) > 0) {
                int totalSecs = data.m_128451_(TAG_DEFENCE_COOLDOWN) / 20;
                int mins = totalSecs % 3600 / 60;
                int secs = totalSecs % 60;
                if (mins > 0) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.defence.cooldown").m_7220_((Component)Component.m_237113_((String)(mins + "m " + secs + "s"))), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.defence.cooldown").m_7220_((Component)Component.m_237113_((String)(secs + "s"))), true);
                }
                player.m_6330_(SoundEvents.f_12217_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            result.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "max_cloak_knockback_resistance").toString(), (double)((Integer)SkillcloaksCommonConfig.STRENGTH_KNOCKBACK_RESISTANCE.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            result.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "fishing_cloak_luck").toString(), (double)((Integer)SkillcloaksCommonConfig.FISHING_LUCK.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }
}

