/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class FarmingCloakItem
extends CurioItem {
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skillcloaks.farming_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"curios.modifiers.cloak").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("+" + ((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).toString() + " ")).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)"tooltip.skillcloaks.armor_value")));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    @SubscribeEvent
    public static void doBonemealEvent(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if ((CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.FARMING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent()) && event.getItemStack().m_41720_().equals(Items.f_42499_)) {
            if (pos == player.m_20097_() || level.m_8055_(pos).m_60734_() instanceof BonemealableBlock) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
            BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
            int xRange = (Integer)SkillcloaksCommonConfig.FARMING_RANGE.get();
            int zRange = (Integer)SkillcloaksCommonConfig.FARMING_RANGE.get();
            for (int xPos = pos.m_123341_() - xRange; xPos <= pos.m_123341_() + xRange; ++xPos) {
                for (int zPos = pos.m_123343_() - zRange; zPos <= pos.m_123343_() + zRange; ++zPos) {
                    BlockPos.MutableBlockPos position = mutableblockpos.m_122178_(xPos, pos.m_123342_(), zPos);
                    Block block = level.m_8055_((BlockPos)position).m_60734_();
                    if (!(block instanceof BonemealableBlock)) continue;
                    BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)level, (BlockPos)position, (Player)player);
                    if (!level.f_46443_) {
                        FarmingCloakItem.addGrowthParticles((ServerLevel)level, (BlockPos)position, (ServerPlayer)player);
                    }
                    level.m_5594_(null, (BlockPos)position, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (!player.m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
        }
    }

    private static void addGrowthParticles(ServerLevel level, BlockPos pos, ServerPlayer player) {
        Random random = new Random();
        int numParticles = 2;
        BlockState blockstate = level.m_8055_(pos);
        if (!blockstate.m_60795_()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.equals(Blocks.f_49990_)) {
                numParticles *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.m_60804_((BlockGetter)level, pos)) {
                pos = pos.m_7494_();
                numParticles *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = 1.0;
            }
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, numParticles, 0.0, 0.0, 0.5, 0.5);
            for (int i = 0; i < numParticles; ++i) {
                double z;
                double y;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                double d4 = random.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double x = (double)pos.m_123341_() + d5 + random.nextDouble() * d0 * 2.0;
                if (level.m_8055_(new BlockPos((int)x, (int)(y = (double)pos.m_123342_() + random.nextDouble() * d1), (int)(z = (double)pos.m_123343_() + d5 + random.nextDouble() * d0 * 2.0)).m_7495_()).m_60795_()) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, numParticles, d2, d3, d4, 0.5);
            }
        }
    }
}

