/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class PrayerCloakItem
extends CurioItem {
    private static final String TAG_HAS_PRAYER_CLOAK = "saveXp";

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skillcloaks.prayer_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"curios.modifiers.cloak").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("+" + ((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).toString() + " ")).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)"tooltip.skillcloaks.armor_value")));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return ICurio.DropRule.DEFAULT;
        }
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    @SubscribeEvent
    public static void onPlayerXpDrop(LivingExperienceDropEvent event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.PRAYER_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLethal(LivingDamageEvent event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        LivingEntity player = event.getEntity();
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        if (event.getAmount() >= player.m_21223_() && (CuriosApi.getCuriosHelper().findFirstCurio(player, (Item)SkillcloaksItems.PRAYER_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio(player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent()) && !data.m_128471_(TAG_HAS_PRAYER_CLOAK)) {
            data.m_128379_(TAG_HAS_PRAYER_CLOAK, true);
            playerData.m_128365_("PlayerPersisted", (Tag)data);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        CompoundTag playerData;
        CompoundTag data;
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        if (event.isWasDeath() && (data = (playerData = event.getOriginal().getPersistentData()).m_128469_("PlayerPersisted")).m_128471_(TAG_HAS_PRAYER_CLOAK) && event.getEntity().f_36079_ <= 0) {
            event.getEntity().m_6756_(event.getOriginal().f_36079_);
            data.m_128473_(TAG_HAS_PRAYER_CLOAK);
        }
    }
}

