/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.network.message;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.mindoth.skillcloaks.client.InventoryCraftingMenu;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class CloakAbilityPacket {
    public static final UUID UNION_UUID = UUID.fromString("e8ef4b7d-f91a-4a40-b020-c44386355641");
    private static final String TAG_MAX_MODE = "skillcloak.mode";
    public int key;
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.crafting");

    public CloakAbilityPacket() {
    }

    public CloakAbilityPacket(int key) {
        this.key = key;
    }

    public static void encode(CloakAbilityPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.key);
    }

    public static CloakAbilityPacket decode(FriendlyByteBuf buffer) {
        return new CloakAbilityPacket(buffer.readInt());
    }

    public static MenuProvider getMenuProvider(Level pLevel, BlockPos pPos) {
        return new SimpleMenuProvider((p_52229_, p_52230_, p_52231_) -> new InventoryCraftingMenu(p_52229_, p_52230_, ContainerLevelAccess.m_39289_((Level)pLevel, (BlockPos)pPos)), CONTAINER_TITLE);
    }

    public static void handle(CloakAbilityPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel world = player.m_9236_();
            CompoundTag playerMaxData = player.getPersistentData();
            CompoundTag maxData = playerMaxData.m_128469_("PlayerPersisted");
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent() && !player.m_36335_().m_41519_((Item)SkillcloaksItems.MAX_CLOAK.get()) && player.m_6047_()) {
                switch (maxData.m_128451_(TAG_MAX_MODE)) {
                    case 1: {
                        maxData.m_128405_(TAG_MAX_MODE, 2);
                        playerMaxData.m_128365_("PlayerPersisted", (Tag)maxData);
                        player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.max.mode.construction"), true);
                        player.m_36335_().m_41524_((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    case 2: {
                        if (ModList.get().isLoaded("lucent")) {
                            maxData.m_128405_(TAG_MAX_MODE, 1);
                        } else {
                            maxData.m_128405_(TAG_MAX_MODE, 3);
                        }
                        playerMaxData.m_128365_("PlayerPersisted", (Tag)maxData);
                        player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.max.mode.crafting"), true);
                        player.m_36335_().m_41524_((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    case 3: {
                        maxData.m_128405_(TAG_MAX_MODE, 1);
                        playerMaxData.m_128365_("PlayerPersisted", (Tag)maxData);
                        player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.max.mode.firemaking"), true);
                        player.m_36335_().m_41524_((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    default: {
                        maxData.m_128405_(TAG_MAX_MODE, 2);
                        playerMaxData.m_128365_("PlayerPersisted", (Tag)maxData);
                        player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.max.mode.construction"), true);
                        player.m_36335_().m_41524_((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                    }
                }
            }
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.CRAFTING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent() && !player.m_6047_()) {
                if (ModList.get().isLoaded("lucent")) {
                    if (maxData.m_128451_(TAG_MAX_MODE) == 1 || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.CRAFTING_CLOAK.get()).isPresent()) {
                        player.m_5893_(CloakAbilityPacket.getMenuProvider(player.f_19853_, player.m_20183_()));
                    }
                } else if (maxData.m_128451_(TAG_MAX_MODE) == 3 || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.CRAFTING_CLOAK.get()).isPresent()) {
                    player.m_5893_(CloakAbilityPacket.getMenuProvider(player.f_19853_, player.m_20183_()));
                }
            }
            if ((CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.CONSTRUCTION_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent() && maxData.m_128451_(TAG_MAX_MODE) == 2 && !player.m_6047_()) && !player.m_36335_().m_41519_((Item)SkillcloaksItems.CONSTRUCTION_CLOAK.get()) && !player.m_36335_().m_41519_((Item)SkillcloaksItems.MAX_CLOAK.get())) {
                ServerLevel respawnWorld = player.f_8924_.m_129880_(player.m_8963_());
                BlockPos spawn = player.m_8961_();
                if (spawn != null && respawnWorld != null) {
                    BlockState blockstate = respawnWorld.m_8055_(spawn);
                    if (respawnWorld == world) {
                        if (blockstate.m_60713_(Blocks.f_50724_) && (Integer)blockstate.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0 && RespawnAnchorBlock.m_55850_((Level)respawnWorld) || blockstate.m_204336_(BlockTags.f_13038_)) {
                            player.m_6027_((double)spawn.m_123341_() + 0.5, (double)(spawn.m_123342_() + 1), (double)spawn.m_123343_() + 0.5);
                            if (blockstate.m_60713_(Blocks.f_50724_)) {
                                respawnWorld.m_7731_(spawn, (BlockState)blockstate.m_61124_((Property)RespawnAnchorBlock.f_55833_, (Comparable)Integer.valueOf((Integer)blockstate.m_61143_((Property)RespawnAnchorBlock.f_55833_) - 1)), 3);
                            }
                            if (Objects.equals(player.m_20148_(), UNION_UUID)) {
                                world.m_6263_(null, (double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_() + 1.5, (double)spawn.m_123343_() + 0.5, SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 0.5f);
                                for (int i = 0; i < 360; ++i) {
                                    if (i % 20 != 0) continue;
                                    respawnWorld.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)spawn.m_123341_() + 0.5 + Math.cos(i) * 1.5, (double)spawn.m_123342_() + 1.5, (double)spawn.m_123343_() + 0.5 + Math.sin(i) * 1.5, 1, 0.0, 0.0, 0.0, 0.0);
                                }
                            } else {
                                world.m_6263_(null, (double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_() + 1.5, (double)spawn.m_123343_() + 0.5, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                for (int i = 0; i < 10; ++i) {
                                    respawnWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)spawn.m_123341_() + 0.5, (double)(spawn.m_123342_() + 1), (double)spawn.m_123343_() + 0.5, (int)(player.m_217043_().m_188500_() * 10.0), (player.m_217043_().m_188500_() - 0.5) * 1.5, -player.m_217043_().m_188500_() + 1.0, (player.m_217043_().m_188500_() - 0.5) * 1.5, 0.0);
                                }
                            }
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.construction.cantfind"), true);
                            player.m_6330_((SoundEvent)SoundEvents.f_12217_.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.construction.wrongdim"), true);
                        player.m_6330_((SoundEvent)SoundEvents.f_12217_.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
                    }
                    player.m_36335_().m_41524_((Item)SkillcloaksItems.CONSTRUCTION_CLOAK.get(), 20);
                    player.m_36335_().m_41524_((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.construction.cantfind"), true);
                    player.m_6330_((SoundEvent)SoundEvents.f_12217_.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
                }
            }
            if (!ModList.get().isLoaded("lucent") && (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.FIREMAKING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent() && maxData.m_128451_(TAG_MAX_MODE) == 1 && !player.m_6047_()) && !player.m_36335_().m_41519_((Item)SkillcloaksItems.FIREMAKING_CLOAK.get()) && !player.m_36335_().m_41519_((Item)SkillcloaksItems.MAX_CLOAK.get())) {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                ItemEntity drop = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), new ItemStack((ItemLike)Items.f_42000_));
                drop.m_20334_(0.0, 0.0, 0.0);
                drop.m_32061_();
                player.f_19853_.m_7967_((Entity)drop);
                player.m_36335_().m_41524_((Item)SkillcloaksItems.FIREMAKING_CLOAK.get(), 20);
                player.m_36335_().m_41524_((Item)SkillcloaksItems.MAX_CLOAK.get(), 20);
            }
        });
        context.setPacketHandled(true);
    }
}

