/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.strange_beasts;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.strange_beasts.StrangeBeastsMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class StrangeBeastsModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public StrangeBeastsModElements() {
        sounds.put(new ResourceLocation("strange_beasts", "froffi_death_sound"), new SoundEvent(new ResourceLocation("strange_beasts", "froffi_death_sound")));
        sounds.put(new ResourceLocation("strange_beasts", "froffi_hurt_sound"), new SoundEvent(new ResourceLocation("strange_beasts", "froffi_hurt_sound")));
        sounds.put(new ResourceLocation("strange_beasts", "froffi_live_sound"), new SoundEvent(new ResourceLocation("strange_beasts", "froffi_live_sound")));
        sounds.put(new ResourceLocation("strange_beasts", "froffib_death_sound"), new SoundEvent(new ResourceLocation("strange_beasts", "froffib_death_sound")));
        sounds.put(new ResourceLocation("strange_beasts", "froffib_hurt_sound"), new SoundEvent(new ResourceLocation("strange_beasts", "froffib_hurt_sound")));
        sounds.put(new ResourceLocation("strange_beasts", "froffib_live_sound"), new SoundEvent(new ResourceLocation("strange_beasts", "froffib_live_sound")));
        sounds.put(new ResourceLocation("strange_beasts", "magpig_death"), new SoundEvent(new ResourceLocation("strange_beasts", "magpig_death")));
        sounds.put(new ResourceLocation("strange_beasts", "magpig_hurt"), new SoundEvent(new ResourceLocation("strange_beasts", "magpig_hurt")));
        sounds.put(new ResourceLocation("strange_beasts", "magpig_live"), new SoundEvent(new ResourceLocation("strange_beasts", "magpig_live")));
        sounds.put(new ResourceLocation("strange_beasts", "crab_ambient"), new SoundEvent(new ResourceLocation("strange_beasts", "crab_ambient")));
        sounds.put(new ResourceLocation("strange_beasts", "ocean_horn"), new SoundEvent(new ResourceLocation("strange_beasts", "ocean_horn")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("strange_beasts").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        StrangeBeastsMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final StrangeBeastsModElements elements;
        protected final int sortid;

        public ModElement(StrangeBeastsModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

