/*
 * Decompiled with CFR 0.152.
 */
package net.cursedwarriorstructuralstatues.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.cursedwarriorstructuralstatues.world.features.StoneStatue1Feature;
import net.cursedwarriorstructuralstatues.world.features.StoneStatue2Feature;
import net.cursedwarriorstructuralstatues.world.features.StoneStatue3Feature;
import net.cursedwarriorstructuralstatues.world.features.StoneStatue4Feature;
import net.cursedwarriorstructuralstatues.world.features.StoneStatueGold1Feature;
import net.cursedwarriorstructuralstatues.world.features.StoneStatueGold2Feature;
import net.cursedwarriorstructuralstatues.world.features.StoneStatueGold3Feature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class StructuralStatuesModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"structural_statues");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> STONE_STATUE_1 = StructuralStatuesModFeatures.register("stone_statue_1", StoneStatue1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, StoneStatue1Feature.GENERATE_BIOMES, StoneStatue1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> STONE_STATUE_2 = StructuralStatuesModFeatures.register("stone_statue_2", StoneStatue2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, StoneStatue2Feature.GENERATE_BIOMES, StoneStatue2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> STONE_STATUE_3 = StructuralStatuesModFeatures.register("stone_statue_3", StoneStatue3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, StoneStatue3Feature.GENERATE_BIOMES, StoneStatue3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> STONE_STATUE_4 = StructuralStatuesModFeatures.register("stone_statue_4", StoneStatue4Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, StoneStatue4Feature.GENERATE_BIOMES, StoneStatue4Feature::placedFeature));
    public static final RegistryObject<Feature<?>> STONE_STATUE_GOLD_1 = StructuralStatuesModFeatures.register("stone_statue_gold_1", StoneStatueGold1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, StoneStatueGold1Feature.GENERATE_BIOMES, StoneStatueGold1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> STONE_STATUE_GOLD_2 = StructuralStatuesModFeatures.register("stone_statue_gold_2", StoneStatueGold2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, StoneStatueGold2Feature.GENERATE_BIOMES, StoneStatueGold2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> STONE_STATUE_GOLD_3 = StructuralStatuesModFeatures.register("stone_statue_gold_3", StoneStatueGold3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, StoneStatueGold3Feature.GENERATE_BIOMES, StoneStatueGold3Feature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

