/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.api;

import com.google.common.collect.Multimap;
import com.google.gson.annotations.SerializedName;
import draylar.tiered.Tiered;
import draylar.tiered.api.util.EntityAttributeModifierUtils;
import draylar.tiered.api.util.EquipmentSlotUtils;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class AttributeTemplate {
    private static final String TYPE_KEY = "Type";
    private static final String MODIFIER_KEY = "Modifier";
    private static final String REQUIRED_KEY = "Required";
    private static final String OPTIONAL_KEY = "Optional";
    @SerializedName(value="type")
    private final String attributeTypeID;
    @SerializedName(value="modifier")
    private final class_1322 entityAttributeModifier;
    @SerializedName(value="required_equipment_slots")
    private class_1304[] requiredEquipmentSlots;
    @SerializedName(value="optional_equipment_slots")
    private class_1304[] optionalEquipmentSlots;

    public AttributeTemplate(String attributeTypeID, class_1322 entityAttributeModifier, class_1304[] requiredEquipmentSlots, class_1304[] optionalEquipmentSlots) {
        this.attributeTypeID = attributeTypeID;
        this.entityAttributeModifier = entityAttributeModifier;
        this.requiredEquipmentSlots = requiredEquipmentSlots;
        this.optionalEquipmentSlots = optionalEquipmentSlots;
    }

    public class_1304[] getRequiredEquipmentSlots() {
        return this.requiredEquipmentSlots;
    }

    public class_1304[] getOptionalEquipmentSlots() {
        return this.optionalEquipmentSlots;
    }

    public void realize(Multimap<String, class_1322> multimap, class_1304 slot) {
        class_1322 cloneModifier = new class_1322(Tiered.MODIFIERS[slot.method_5926()], this.entityAttributeModifier.method_6185() + "_" + slot.method_5923(), this.entityAttributeModifier.method_6186(), this.entityAttributeModifier.method_6182());
        multimap.put((Object)this.attributeTypeID, (Object)cloneModifier);
    }

    public class_2520 toTag() {
        class_2487 tag = new class_2487();
        if (this.requiredEquipmentSlots == null) {
            this.requiredEquipmentSlots = new class_1304[0];
        }
        if (this.optionalEquipmentSlots == null) {
            this.optionalEquipmentSlots = new class_1304[0];
        }
        tag.method_10582(TYPE_KEY, this.attributeTypeID);
        tag.method_10566(MODIFIER_KEY, EntityAttributeModifierUtils.toTag(this.entityAttributeModifier));
        tag.method_10566(REQUIRED_KEY, (class_2520)EquipmentSlotUtils.toTag(this.requiredEquipmentSlots));
        tag.method_10566(OPTIONAL_KEY, (class_2520)EquipmentSlotUtils.toTag(this.optionalEquipmentSlots));
        return tag;
    }

    public static AttributeTemplate fromTag(class_2487 tag) {
        return new AttributeTemplate(tag.method_10558(TYPE_KEY), EntityAttributeModifierUtils.fromTag((class_2487)tag.method_10580(MODIFIER_KEY)), EquipmentSlotUtils.fromTag((class_2499)tag.method_10580(REQUIRED_KEY)), EquipmentSlotUtils.fromTag((class_2499)tag.method_10580(OPTIONAL_KEY)));
    }
}

