/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.autotag.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import io.github.apace100.autotag.AutoTag;
import io.github.apace100.autotag.AutoTagRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_2370.class})
public abstract class SimpleRegistryMixin<T>
extends class_2385<T> {
    @Shadow
    public abstract Stream<class_6880.class_6883<T>> method_40270();

    public SimpleRegistryMixin(class_5321<? extends class_2378<T>> registryKey, Lifecycle lifecycle) {
        super(registryKey, lifecycle);
    }

    @ModifyVariable(method={"populateTags"}, at=@At(value="HEAD"), argsOnly=true)
    private Map<class_6862<T>, List<class_6880<T>>> addAutomaticTagEntries(Map<class_6862<T>, List<class_6880<T>>> tagEntries) {
        if (tagEntries instanceof HashMap) {
            return tagEntries;
        }
        List<AutoTagRegistry.AutoTag<?>> autoTags = AutoTagRegistry.getAutoTags(this);
        if (autoTags.size() == 0) {
            return tagEntries;
        }
        HashMap returnMap = tagEntries;
        HashMap finalReturnMap = returnMap = Maps.newHashMap(returnMap);
        HashSet madeListMutable = new HashSet();
        class_6862 universalPreventTag = AutoTag.getUniversalPreventTag(autoTags.get(0).preventTagKey().comp_326());
        this.method_40270().forEach(entry -> {
            Object value = entry.comp_349();
            for (AutoTagRegistry.AutoTag autoTag : autoTags) {
                LinkedList entryList;
                Predicate<Object> predicate = autoTag.predicate();
                class_6862 preventTagKey = autoTag.preventTagKey();
                if (tagEntries.containsKey(preventTagKey) && ((List)tagEntries.get(preventTagKey)).contains(entry) || tagEntries.containsKey(universalPreventTag) && ((List)tagEntries.get(universalPreventTag)).contains(entry) || !predicate.test(value)) continue;
                class_6862 tagKey = autoTag.tagKey();
                if (finalReturnMap.containsKey(tagKey)) {
                    entryList = (List)finalReturnMap.get(tagKey);
                    if (!madeListMutable.contains(tagKey)) {
                        entryList = Lists.newLinkedList(entryList);
                        finalReturnMap.put(tagKey, entryList);
                        madeListMutable.add(tagKey);
                    }
                } else {
                    entryList = new LinkedList();
                    finalReturnMap.put(tagKey, entryList);
                    madeListMutable.add(tagKey);
                }
                entryList.add(entry);
            }
        });
        autoTags.forEach(autoTag -> finalReturnMap.remove(autoTag.preventTagKey()));
        finalReturnMap.remove(universalPreventTag);
        return finalReturnMap;
    }
}

