/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.api;

import com.google.common.collect.Multimap;
import com.google.gson.annotations.SerializedName;
import draylar.tiered.Tiered;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class AttributeTemplate {
    @SerializedName(value="type")
    private final String attributeTypeID;
    @SerializedName(value="modifier")
    private final AttributeModifier attributeModifier;
    @SerializedName(value="required_equipment_slots")
    private final EquipmentSlotType[] requiredEquipmentSlotTypes;
    @SerializedName(value="optional_equipment_slots")
    private final EquipmentSlotType[] optionalEquipmentSlotTypes;

    public AttributeTemplate(String attributeTypeID, AttributeModifier AttributeModifier2, EquipmentSlotType[] requiredEquipmentSlotTypes, EquipmentSlotType[] optionalEquipmentSlotTypes) {
        this.attributeTypeID = attributeTypeID;
        this.attributeModifier = AttributeModifier2;
        this.requiredEquipmentSlotTypes = requiredEquipmentSlotTypes;
        this.optionalEquipmentSlotTypes = optionalEquipmentSlotTypes;
    }

    public EquipmentSlotType[] getRequiredEquipmentSlot() {
        return this.requiredEquipmentSlotTypes;
    }

    public EquipmentSlotType[] getOptionalEquipmentSlot() {
        return this.optionalEquipmentSlotTypes;
    }

    public void realize(Multimap<Attribute, AttributeModifier> multimap, EquipmentSlotType slot) {
        AttributeModifier cloneModifier = new AttributeModifier(Tiered.MODIFIERS[slot.func_188452_c()], this.attributeModifier.func_111166_b() + "_" + slot.func_188450_d(), this.attributeModifier.func_111164_d(), this.attributeModifier.func_220375_c());
        Attribute key = (Attribute)Registry.field_239692_aP_.func_82594_a(new ResourceLocation(this.attributeTypeID));
        if (key == null) {
            Tiered.LOGGER.warn(String.format("%s was referenced as an attribute type, but it does not exist! A data file in /tiered/item_attributes/ has an invalid type property.", this.attributeTypeID));
        } else {
            multimap.put((Object)key, (Object)cloneModifier);
        }
    }
}

