/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.mixin;

import com.mojang.authlib.GameProfile;
import draylar.tiered.api.ModifierUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntity {
    private NonNullList<ItemStack> mainCopy = null;

    private ServerPlayerEntityMixin(World world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.mainCopy == null) {
            this.mainCopy = this.copyDefaultedList((NonNullList<ItemStack>)this.field_71071_by.field_70462_a);
            this.runCheck();
        }
        if (!this.field_71071_by.field_70462_a.equals(this.mainCopy)) {
            this.mainCopy = this.copyDefaultedList((NonNullList<ItemStack>)this.field_71071_by.field_70462_a);
            this.runCheck();
        }
    }

    @Unique
    private NonNullList<ItemStack> copyDefaultedList(NonNullList<ItemStack> list) {
        NonNullList newList = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            newList.set(i, list.get(i));
        }
        return newList;
    }

    @Unique
    private void runCheck() {
        this.field_71071_by.field_70462_a.forEach(itemStack -> {
            ResourceLocation potentialAttributeID;
            if (itemStack.func_179543_a("Tiered") == null && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(itemStack.func_77973_b())) != null) {
                itemStack.func_190925_c("Tiered").func_74778_a("Tier", potentialAttributeID.toString());
            }
        });
    }
}

