/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.network;

import draylar.tiered.Tiered;
import draylar.tiered.api.PotentialAttribute;
import draylar.tiered.data.AttributeDataLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class AttributeSyncer {
    public int size = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().size();
    public Map<ResourceLocation, PotentialAttribute> attribute = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes();
    public static final Map<ResourceLocation, PotentialAttribute> CACHED_ATTRIBUTES = new HashMap<ResourceLocation, PotentialAttribute>();

    public static AttributeSyncer decode(PacketBuffer buf) {
        AttributeSyncer packet = new AttributeSyncer();
        packet.size = buf.readInt();
        for (int i = 0; i < packet.size; ++i) {
            ResourceLocation id = new ResourceLocation(buf.func_218666_n());
            PotentialAttribute pa = (PotentialAttribute)AttributeDataLoader.GSON.fromJson(buf.func_218666_n(), PotentialAttribute.class);
            packet.attribute.put(id, pa);
        }
        return packet;
    }

    public static void encode(AttributeSyncer packet, PacketBuffer buf) {
        buf.writeInt(packet.size);
        packet.attribute.forEach((id, attribute) -> {
            buf.func_180714_a(id.toString());
            buf.func_180714_a(AttributeDataLoader.GSON.toJson(attribute));
        });
    }

    public static void handlePacket(AttributeSyncer packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                CACHED_ATTRIBUTES.putAll(Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes());
                Tiered.ATTRIBUTE_DATA_LOADER.clear();
                Tiered.ATTRIBUTE_DATA_LOADER.replace(packet.attribute);
                if (Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().size() == 0) {
                    Tiered.ATTRIBUTE_DATA_LOADER.replace(CACHED_ATTRIBUTES);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

