/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientCape {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final Logger logger = LogManager.getLogger((String)"unionlib");
    private static final JsonParser parser = new JsonParser();
    private static final Map<UUID, String> CAPES_LOCATION = Maps.newHashMap();

    public static void loadCapes() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/Stereowalker/UnionLib/1.16-forge/capes.json");
            URLConnection connection = url.openConnection();
            connection.connect();
            System.out.println("Found the cape Json file on GitHub");
            BufferedReader read = new BufferedReader(new InputStreamReader(url.openStream()));
            JsonObject object = parser.parse((Reader)read).getAsJsonObject();
            for (Map.Entry element : object.entrySet()) {
                System.out.println("Found cape for " + (String)element.getKey() + " they seem to want to use the " + ((JsonElement)element.getValue()).getAsString() + " cape");
                CAPES_LOCATION.put(UUID.fromString((String)element.getKey()), ((JsonElement)element.getValue()).getAsString());
            }
            read.close();
        }
        catch (MalformedURLException e) {
            System.out.println("Internet is not connected");
        }
        catch (IOException e) {
            System.out.println("Internet is not connected");
        }
    }

    public static void queuePlayerCapeReplacement(AbstractClientPlayerEntity player) {
        String displayName = player.func_145748_c_().getString();
        logger.info("Queueing cape replacement for " + displayName);
        THREAD_POOL.submit(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.fatal("Cape delay thread for " + displayName + " interrupted");
                return;
            }
            Minecraft.func_71410_x().func_213165_a(() -> ClientCape.replacePlayerCape(player));
        });
    }

    private static void replacePlayerCape(AbstractClientPlayerEntity player) {
        String displayName = player.func_145748_c_().getString();
        NetworkPlayerInfo playerInfo = player.func_175155_b();
        if (playerInfo == null) {
            logger.info("NetworkPlayerInfo of " + displayName + " is null. Cannot add cape");
            return;
        }
        Map playerTextures = playerInfo.field_187107_a;
        playerTextures.put(MinecraftProfileTexture.Type.CAPE, new ResourceLocation("unionlib", "textures/cape/" + CAPES_LOCATION.get(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH())) + ".png"));
        logger.info("Looking for cape texture at " + new ResourceLocation("unionlib", "textures/cape/" + CAPES_LOCATION.get(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH())) + ".png").func_110623_a());
        logger.info("Replaced cape of " + displayName);
    }

    public static boolean doesPlayerNeedCapeClient(AbstractClientPlayerEntity player) {
        return CAPES_LOCATION.containsKey(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()));
    }
}

