/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.stereowalker.unionlib.ClientCape;
import com.stereowalker.unionlib.client.gui.screen.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screen.inventory.UScreens;
import com.stereowalker.unionlib.client.keybindings.KeyBindings;
import com.stereowalker.unionlib.config.Config;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.entity.ai.UAttributes;
import com.stereowalker.unionlib.inventory.UnionInventory;
import com.stereowalker.unionlib.mod.UnionMod;
import com.stereowalker.unionlib.network.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="unionlib")
public class UnionLib {
    public static UnionLib instance;
    public static final String MOD_ID = "unionlib";
    public static final Logger LOGGER;
    public static final String INVENTORY_KEY = "UnionInventory";
    private static final String NETWORK_PROTOCOL_VERSION = "1";
    public static boolean debugMode;
    public static List<UnionMod> mods;
    public static final SimpleChannel CHANNEL;

    public static void debug(String message) {
        if (debugMode) {
            LOGGER.debug(message);
        }
    }

    public static void warn(String message) {
        if (debugMode) {
            LOGGER.warn(message);
        }
    }

    public static boolean disableConfig() {
        return false;
    }

    public UnionLib() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigBuilder.registerConfig(Config.class);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        UAttributes.registerAll(modEventBus);
        PacketRegistry.registerMessages(CHANNEL);
        ClientCape.loadCapes();
        for (int i = 0; i < 10; ++i) {
            new UnionMod("concept" + i, UnionLib.location("name"), UnionMod.LoadType.BOTH, !FMLEnvironment.production){

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                    return new ConfigScreen(previousScreen, Config.class, (ITextComponent)new TranslationTextComponent("Config"));
                }
            };
        }
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        KeyBindings.registerKeyBindings();
        UScreens.registerScreens();
    }

    public static ResourceLocation location(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static UnionInventory getAccessoryInventory(PlayerEntity player) {
        UnionInventory inventory = new UnionInventory(player);
        inventory.func_70486_a(player.getPersistentData().func_150295_c(INVENTORY_KEY, 10));
        return inventory;
    }

    public static void saveInventory(PlayerEntity player, UnionInventory inventory) {
        player.getPersistentData().func_218657_a(INVENTORY_KEY, (INBT)inventory.func_70487_g());
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
        debugMode = false;
        mods = new ArrayList<UnionMod>();
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)UnionLib.location("main"), () -> NETWORK_PROTOCOL_VERSION, NETWORK_PROTOCOL_VERSION::equals, NETWORK_PROTOCOL_VERSION::equals);
    }
}

