/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.widget.list;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.stereowalker.unionlib.client.gui.screen.ConfigScreen;
import com.stereowalker.unionlib.client.gui.widget.button.Slider;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ConfigList
extends AbstractOptionList<Entry> {
    protected ConfigScreen screen;
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    public ConfigList(Minecraft mcIn, ConfigScreen screen, UnionConfig config) {
        super(mcIn, screen.field_230708_k_ + 45, screen.field_230709_l_, 43, screen.field_230709_l_ - 32, 25);
        this.screen = screen;
        List<String> c = Arrays.asList(ConfigBuilder.getValues(config).keySet().toArray(new String[0]));
        Collections.sort(c);
        String currentCategory = "";
        for (String configValue : c) {
            String name = "";
            for (int i = 1; i < configValue.split("=").length; ++i) {
                name = name + configValue.split("=")[i];
            }
            if (ConfigList.split(name).size() > 1 && !ConfigList.split(name).get(0).equals(currentCategory)) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new CategoryEntry((ITextComponent)new TranslationTextComponent(ConfigList.split(name).get(0))));
                currentCategory = ConfigList.split(name).get(0);
            }
            String name2 = "";
            for (int i = 1; i < ConfigList.split(name).size(); ++i) {
                name2 = name2 + ConfigList.split(name).get(i);
            }
            ConfigBuilder.Holder holder = ConfigBuilder.getValues(config).get(configValue);
            boolean usesSlider = ConfigBuilder.getValues(config).get(configValue).isUsesSider();
            List<ITextComponent> comment = ConfigBuilder.getValues(config).get(configValue).getComments();
            if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Boolean) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new BooleanEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue()));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof String) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new StringEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue()));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Enum) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new EnumEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue()));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Number) {
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Double) {
                    this.func_230513_b_((AbstractList.AbstractListEntry)new NumberedEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Float) {
                    this.func_230513_b_((AbstractList.AbstractListEntry)new NumberedEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Long) {
                    this.func_230513_b_((AbstractList.AbstractListEntry)new NumberedEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Short) {
                    this.func_230513_b_((AbstractList.AbstractListEntry)new NumberedEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Byte) {
                    this.func_230513_b_((AbstractList.AbstractListEntry)new NumberedEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                this.func_230513_b_((AbstractList.AbstractListEntry)new NumberedEntry((ITextComponent)new TranslationTextComponent(name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                continue;
            }
            this.func_230513_b_((AbstractList.AbstractListEntry)new ConfigEntry((ITextComponent)new TranslationTextComponent(name2), ConfigBuilder.getValues(config).get(configValue).getComments()));
        }
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 15 + 40;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 72;
    }

    public void tick() {
        for (Entry ent : this.func_231039_at__()) {
            if (!(ent instanceof ConfigEntry)) continue;
            ((ConfigEntry)ent).tick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class NumberedEntry<V extends Number>
    extends ConfigEntry {
        private final ForgeConfigSpec.ConfigValue<V> config;
        private final TextFieldWidget stringField;
        private final Slider slider;
        private final boolean useSlider;

        private NumberedEntry(ITextComponent name, List<ITextComponent> comment, final ForgeConfigSpec.ConfigValue<V> config, boolean useSlider, final double min, double max) {
            super(name, comment);
            this.config = config;
            this.useSlider = useSlider;
            final double shiftedMax = max - min;
            this.slider = new Slider(0, 0, 200, 20, ((Number)config.get()).doubleValue() / shiftedMax, (ITextComponent)new StringTextComponent(((Number)config.get()).toString())){

                @Override
                protected void func_230972_a_() {
                    if (NumberedEntry.this.useSlider) {
                        Number oldValue = (Number)config.get();
                        Double newValue = this.field_230683_b_ * shiftedMax + min;
                        try {
                            if (config.get() instanceof Double) {
                                NumberedEntry.this.config.set((Object)newValue);
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Float) {
                                NumberedEntry.this.config.set((Object)Float.valueOf(newValue.floatValue()));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Long) {
                                NumberedEntry.this.config.set((Object)newValue.longValue());
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Short) {
                                NumberedEntry.this.config.set((Object)newValue.shortValue());
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Byte) {
                                NumberedEntry.this.config.set((Object)newValue.byteValue());
                                ConfigBuilder.reload();
                            } else {
                                NumberedEntry.this.config.set((Object)newValue.intValue());
                                ConfigBuilder.reload();
                            }
                        }
                        catch (NumberFormatException e) {
                            config.set((Object)oldValue);
                            ConfigBuilder.reload();
                        }
                        this.func_238482_a_((ITextComponent)new StringTextComponent(((Number)NumberedEntry.this.config.get()).toString()));
                    }
                }
            };
            this.stringField = new TextFieldWidget(((ConfigList)ConfigList.this).field_230668_b_.field_71466_p, 0, 0, 200, 20, (ITextComponent)new TranslationTextComponent("config.editNumber")){

                public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
                    if (keyCode == 257) {
                        this.updateValues();
                    }
                    return super.func_231046_a_(keyCode, scanCode, modifiers);
                }

                protected void func_230995_c_(boolean focused) {
                    super.func_230995_c_(focused);
                }

                public void func_146178_a() {
                    if (!this.func_230999_j_() && !this.func_146179_b().equals(((Number)config.get()).toString())) {
                        this.updateValues();
                    }
                    super.func_146178_a();
                }

                public void updateValues() {
                    if (!NumberedEntry.this.useSlider) {
                        Number oldValue = (Number)config.get();
                        try {
                            if (config.get() instanceof Double) {
                                NumberedEntry.this.config.set((Object)Double.parseDouble(this.func_146179_b()));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Float) {
                                NumberedEntry.this.config.set((Object)Float.valueOf(Float.parseFloat(this.func_146179_b())));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Long) {
                                NumberedEntry.this.config.set((Object)Long.parseLong(this.func_146179_b()));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Short) {
                                NumberedEntry.this.config.set((Object)Short.parseShort(this.func_146179_b()));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Byte) {
                                NumberedEntry.this.config.set((Object)Byte.parseByte(this.func_146179_b()));
                                ConfigBuilder.reload();
                            } else {
                                NumberedEntry.this.config.set((Object)Integer.parseInt(this.func_146179_b()));
                                ConfigBuilder.reload();
                            }
                        }
                        catch (NumberFormatException e) {
                            config.set((Object)oldValue);
                            ConfigBuilder.reload();
                            this.func_146180_a(oldValue.toString());
                        }
                    }
                }
            };
            this.stringField.func_146180_a(((Number)this.config.get()).toString());
            ConfigList.this.screen.addChild((IGuiEventListener)this.stringField);
        }

        public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
            return this.stringField.func_231046_a_(keyCode, scanCode, modifiers);
        }

        public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return this.slider.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }

        @Override
        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.func_230432_a_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            if (this.useSlider) {
                this.slider.field_230690_l_ = p_230432_4_ + 120;
                this.slider.field_230691_m_ = p_230432_3_;
                this.slider.func_230430_a_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            } else {
                this.stringField.field_230690_l_ = p_230432_4_ + 120;
                this.stringField.field_230691_m_ = p_230432_3_;
                this.stringField.func_230430_a_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            }
        }

        @Override
        public void tick() {
            this.stringField.func_146178_a();
            super.tick();
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.stringField, (Object)((Object)this.slider));
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.slider.func_231044_a_(mouseX, mouseY, button)) {
                return true;
            }
            return this.stringField.func_231044_a_(mouseX, mouseY, button);
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            return this.stringField.func_231048_c_(mouseX, mouseY, button) || this.slider.func_231048_c_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class StringEntry
    extends ConfigEntry {
        private final ForgeConfigSpec.ConfigValue<String> config;
        private final TextFieldWidget stringField;

        private StringEntry(ITextComponent name, List<ITextComponent> comment, ForgeConfigSpec.ConfigValue<String> config) {
            super(name, comment);
            this.config = config;
            this.stringField = new TextFieldWidget(((ConfigList)ConfigList.this).field_230668_b_.field_71466_p, 0, 0, 200, 20, (ITextComponent)new TranslationTextComponent("config.editBox"));
            this.stringField.func_146180_a((String)this.config.get());
            this.stringField.func_212954_a(p_214319_1_ -> {
                this.config.set(p_214319_1_);
                ConfigBuilder.reload();
            });
            ConfigList.this.screen.addChild((IGuiEventListener)this.stringField);
        }

        @Override
        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.func_230432_a_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.stringField.field_230690_l_ = p_230432_4_ + 120;
            this.stringField.field_230691_m_ = p_230432_3_;
            this.stringField.func_230430_a_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        @Override
        public void tick() {
            this.stringField.func_146178_a();
            super.tick();
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.stringField);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            return this.stringField.func_231044_a_(mouseX, mouseY, button);
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            return this.stringField.func_231048_c_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BooleanEntry
    extends ConfigEntry {
        private final ForgeConfigSpec.ConfigValue<Boolean> config;
        private final Button booleanButton;

        private BooleanEntry(ITextComponent name, List<ITextComponent> comment, ForgeConfigSpec.ConfigValue<Boolean> config) {
            super(name, comment);
            this.config = config;
            this.booleanButton = new Button(0, 0, 200, 20, name, onPress -> {
                config.set((Object)((Boolean)config.get() == false ? 1 : 0));
                ConfigBuilder.reload();
            });
        }

        @Override
        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.func_230432_a_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.booleanButton.field_230690_l_ = p_230432_4_ + 120;
            this.booleanButton.field_230691_m_ = p_230432_3_;
            this.booleanButton.func_230430_a_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            this.booleanButton.func_238482_a_(DialogTexts.func_240638_a_((boolean)((Boolean)this.config.get())));
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.booleanButton);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            return this.booleanButton.func_231044_a_(mouseX, mouseY, button);
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            return this.booleanButton.func_231048_c_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EnumEntry
    extends ConfigEntry {
        private final ForgeConfigSpec.ConfigValue<Enum<?>> config;
        private final Button enumButton;

        private EnumEntry(ITextComponent name, List<ITextComponent> comment, ForgeConfigSpec.ConfigValue<Enum<?>> config) {
            super(name, comment);
            this.config = config;
            this.enumButton = new Button(0, 0, 200, 20, name, onPress -> {
                config.set((Object)RegistryHelper.rotateEnumForward((Enum)((Enum)config.get()), (Enum[])((Enum[])((Enum)config.get()).getDeclaringClass().getEnumConstants())));
                ConfigBuilder.reload();
            });
        }

        @Override
        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.func_230432_a_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.enumButton.field_230690_l_ = p_230432_4_ + 120;
            this.enumButton.field_230691_m_ = p_230432_3_;
            this.enumButton.func_230430_a_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            this.enumButton.func_238482_a_((ITextComponent)new TranslationTextComponent(((Enum)this.config.get()).name()));
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.enumButton);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            return this.enumButton.func_231044_a_(mouseX, mouseY, button);
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            return this.enumButton.func_231048_c_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ConfigEntry
    extends Entry {
        private final Button configButton;

        public void tick() {
        }

        private ConfigEntry(ITextComponent name, List<ITextComponent> comment) {
            this.configButton = new Button(0, 0, 200, 20, name, onPress -> {}, (button, stack, x, y) -> {
                int space = ((ConfigList)ConfigList.this).field_230668_b_.field_71462_r.field_230709_l_ - y;
                int textHeight = comment.size();
                int drawY = y;
                if (textHeight * 15 > space) {
                    drawY -= textHeight * 15 - space;
                }
                if (comment != null) {
                    ((ConfigList)ConfigList.this).field_230668_b_.field_71462_r.func_243308_b(stack, comment, x, drawY);
                }
            });
        }

        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            this.configButton.field_230690_l_ = p_230432_4_ - 100;
            this.configButton.field_230691_m_ = p_230432_3_;
            this.configButton.func_230430_a_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            this.configButton.field_230693_o_ = false;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.configButton);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        private final ITextComponent labelText;
        private final int labelWidth;

        public CategoryEntry(ITextComponent p_i232280_2_) {
            this.labelText = p_i232280_2_;
            this.labelWidth = ((ConfigList)ConfigList.this).field_230668_b_.field_71466_p.func_238414_a_((ITextProperties)this.labelText);
        }

        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ((ConfigList)ConfigList.this).field_230668_b_.field_71466_p.func_243248_b(p_230432_1_, this.labelText, (float)(((ConfigList)ConfigList.this).field_230668_b_.field_71462_r.field_230708_k_ / 2 - this.labelWidth / 2), (float)(p_230432_3_ + p_230432_6_ - 9 - 1), 0xFFFFFF);
        }

        public boolean func_231049_c__(boolean focus) {
            return false;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
    }
}

