/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stereowalker.unionlib.config.CommentedEnum;
import com.stereowalker.unionlib.config.UnionConfig;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigBuilder {
    private static Map<String, Holder> values = new HashMap<String, Holder>();
    private static final List<Class<?>> configs = Lists.newArrayList();
    public static final Map<Class<?>, Boolean> config_initialization = Maps.newHashMap();
    private static final Map<Class<?>, ForgeConfigSpec.Builder> client_builder = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> client_config = Maps.newHashMap();
    private static final Map<Class<?>, ForgeConfigSpec.Builder> common_builder = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> common_config = Maps.newHashMap();
    private static final Map<Class<?>, ForgeConfigSpec.Builder> server_builder = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> server_config = Maps.newHashMap();
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    public static String configName(UnionConfig.Entry configEntry, String dataType) {
        if (configEntry.group() == "") {
            if (dataType != "") {
                return dataType + ": " + configEntry.name();
            }
            return configEntry.name();
        }
        if (dataType != "") {
            return configEntry.group() + "." + dataType + ": " + configEntry.name();
        }
        return configEntry.group() + "." + configEntry.name();
    }

    public static String configName(UnionConfig.Entry configEntry) {
        return ConfigBuilder.configName(configEntry, "");
    }

    private static ForgeConfigSpec.ConfigValue<?> getConfigValue(UnionConfig config, UnionConfig.Entry configEntry) {
        if (config != null && configEntry != null) {
            return values.getOrDefault(config.name() + "=" + ConfigBuilder.configName(configEntry), new Holder(new ForgeConfigSpec.Builder().define("empty", (Object)"nothing_was_found"), null, false, 0.0, 0.0)).getValue();
        }
        return null;
    }

    public static Map<String, Holder> getValues(UnionConfig config) {
        HashMap<String, Holder> values2 = new HashMap<String, Holder>();
        for (String configValue : values.keySet()) {
            if (!configValue.split("=")[0].equals(config.name())) continue;
            values2.put(configValue, values.get(configValue));
        }
        return values2;
    }

    public static void read(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null) continue;
                try {
                    if (ConfigBuilder.getConfigValue(config, configEntry).get() instanceof Double && field.get(null) instanceof Float) {
                        field.set(null, Float.valueOf(((Double)ConfigBuilder.getConfigValue(config, configEntry).get()).floatValue()));
                        continue;
                    }
                    field.set(null, ConfigBuilder.getConfigValue(config, configEntry).get());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void write(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || ConfigBuilder.getConfigValue(config, configEntry) == null) continue;
                try {
                    ConfigBuilder.getConfigValue(config, configEntry).set(field.get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean hasConfigType(Class<?> configClass, ModConfig.Type type) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || configEntry.type() != type) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void init(Class<?> configClass, ForgeConfigSpec.Builder server, ForgeConfigSpec.Builder common, ForgeConfigSpec.Builder client) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null) continue;
                ModConfig.Type type = configEntry.type() != null ? configEntry.type() : ModConfig.Type.COMMON;
                ForgeConfigSpec.Builder builder = common;
                builder = type == ModConfig.Type.CLIENT ? client : (type == ModConfig.Type.SERVER ? server : common);
                try {
                    ForgeConfigSpec.ConfigValue conf;
                    String enumComment = "";
                    if (field.get(null) instanceof CommentedEnum && field.get(null) instanceof Enum) {
                        enumComment = ((CommentedEnum)field.get(null)).getConfigComment();
                    }
                    enumComment = enumComment + "\n";
                    String j = "\n###########################################";
                    String k = "\n-------------------------------------------";
                    String h = j + "\n";
                    String comment = "";
                    ArrayList<ITextComponent> saved_comment = new ArrayList<ITextComponent>();
                    if (field.isAnnotationPresent(UnionConfig.Comment.class)) {
                        void var19_22;
                        String string = field.getAnnotation(UnionConfig.Comment.class).comment()[0];
                        if (field.getAnnotation(UnionConfig.Comment.class).comment().length > 1) {
                            for (int i = 1; i < field.getAnnotation(UnionConfig.Comment.class).comment().length; ++i) {
                                String string2 = (String)var19_22 + "\n" + field.getAnnotation(UnionConfig.Comment.class).comment()[i];
                            }
                        }
                        comment = h + (String)var19_22 + k + enumComment + "Default: " + field.get(null) + k;
                        for (String s : var19_22.split("\n")) {
                            saved_comment.add((ITextComponent)new StringTextComponent(s).func_240699_a_(TextFormatting.AQUA));
                        }
                        String[] i = enumComment.split("\n");
                        int n = i.length;
                        for (int i2 = 0; i2 < n; ++i2) {
                            String s;
                            s = i[i2];
                            saved_comment.add((ITextComponent)new StringTextComponent(s).func_240699_a_(TextFormatting.YELLOW));
                        }
                        saved_comment.add((ITextComponent)new StringTextComponent("Default: " + field.get(null)).func_240699_a_(TextFormatting.GREEN));
                    } else {
                        comment = h + enumComment + "Default: " + field.get(null) + k;
                        for (String s : enumComment.split("\n")) {
                            saved_comment.add((ITextComponent)new StringTextComponent(s).func_240699_a_(TextFormatting.YELLOW));
                        }
                        saved_comment.add((ITextComponent)new StringTextComponent("Default: " + field.get(null)).func_240699_a_(TextFormatting.GREEN));
                    }
                    ForgeConfigSpec.Builder builder2 = builder.comment(comment);
                    Double min = 0.0;
                    Double max = 0.0;
                    if (field.get(null) instanceof Boolean) {
                        conf = builder2.define(ConfigBuilder.configName(configEntry, "Boolean"), (Object)((Boolean)field.get(null)));
                    } else if (field.get(null) instanceof Enum) {
                        Enum defaultValue = (Enum)field.get(null);
                        List acceptableValues = Arrays.asList(defaultValue.getDeclaringClass().getEnumConstants());
                        conf = builder2.defineEnum(ConfigBuilder.split(ConfigBuilder.configName(configEntry, "Enum")), Enum.valueOf(defaultValue.getDeclaringClass(), defaultValue.name()), EnumGetMethod.NAME_IGNORECASE, obj -> {
                            if (obj instanceof Enum) {
                                return acceptableValues.contains(obj);
                            }
                            if (obj == null) {
                                return false;
                            }
                            try {
                                return acceptableValues.contains(EnumGetMethod.NAME_IGNORECASE.get(obj, defaultValue.getDeclaringClass()));
                            }
                            catch (ClassCastException | IllegalArgumentException e) {
                                return false;
                            }
                        });
                    } else if (field.get(null) instanceof String) {
                        conf = builder2.define(ConfigBuilder.configName(configEntry, "String"), (Object)((String)field.get(null)));
                    } else if (field.isAnnotationPresent(UnionConfig.Range.class)) {
                        UnionConfig.Range range = field.getAnnotation(UnionConfig.Range.class);
                        min = range.min();
                        max = range.max();
                        conf = field.get(null) instanceof Integer ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Integer"), (Comparable)((Integer)field.get(null)), (Comparable)Integer.valueOf(min.intValue()), (Comparable)Integer.valueOf(max.intValue()), Integer.class) : (field.get(null) instanceof Float ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Float"), (Comparable)((Float)field.get(null)), (Comparable)Float.valueOf(min.floatValue()), (Comparable)Float.valueOf(max.floatValue()), Float.class) : (field.get(null) instanceof Long ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Long"), (Comparable)((Long)field.get(null)), (Comparable)Long.valueOf(min.longValue()), (Comparable)Long.valueOf(max.longValue()), Long.class) : (field.get(null) instanceof Short ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Short"), (Comparable)((Short)field.get(null)), (Comparable)Short.valueOf(min.shortValue()), (Comparable)Short.valueOf(max.shortValue()), Short.class) : (field.get(null) instanceof Byte ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Byte"), (Comparable)((Byte)field.get(null)), (Comparable)Byte.valueOf(min.byteValue()), (Comparable)Byte.valueOf(max.byteValue()), Byte.class) : builder2.defineInRange(ConfigBuilder.configName(configEntry, "Double"), (Comparable)((Double)field.get(null)), (Comparable)min, (Comparable)max, Double.class)))));
                    } else {
                        conf = builder2.define(ConfigBuilder.configName(configEntry), field.get(null));
                    }
                    values.put(config.name() + "=" + ConfigBuilder.configName(configEntry), new Holder(conf, saved_comment, field.isAnnotationPresent(UnionConfig.Slider.class), min, max));
                    config_initialization.put(configClass, true);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void registerConfig(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig con = configClass.getAnnotation(UnionConfig.class);
            System.out.println("Registered the config for " + con.name());
            configs.add(configClass);
            client_builder.put(configClass, new ForgeConfigSpec.Builder());
            common_builder.put(configClass, new ForgeConfigSpec.Builder());
            server_builder.put(configClass, new ForgeConfigSpec.Builder());
            ConfigBuilder.registerConfigurations(configClass);
            ConfigBuilder.loadConfigs(configClass);
            ConfigBuilder.read(configClass);
        }
    }

    public static void loadConfig(ForgeConfigSpec config, String path, String fileName) {
        File configFile = new File(path, fileName);
        configFile.getParentFile().mkdirs();
        System.out.println(path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)configFile).sync().autosave().preserveInsertionOrder().onFileNotFound((newfile, configFormat) -> ConfigBuilder.setupConfigFile(configFile, newfile, configFormat)).writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    private static boolean setupConfigFile(File path, Path file, ConfigFormat<?> conf) throws IOException {
        Path p = Paths.get(path.getPath(), new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public static void registerConfigurations(Class<?> configClass) {
        UnionConfig con = configClass.getAnnotation(UnionConfig.class);
        String name = con.folder().isEmpty() ? con.name() : con.folder() + "\\" + con.name();
        ConfigBuilder.init(configClass, server_builder.get(configClass), common_builder.get(configClass), client_builder.get(configClass));
        server_config.put(configClass, server_builder.get(configClass).build());
        client_config.put(configClass, client_builder.get(configClass).build());
        common_config.put(configClass, common_builder.get(configClass).build());
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.CLIENT)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, client_config.get(configClass), name + (con.appendWithType() ? ".client" : "") + ".toml");
        }
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.COMMON)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, common_config.get(configClass), name + (con.appendWithType() ? ".common" : "") + ".toml");
        }
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.SERVER)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, server_config.get(configClass), name + (con.appendWithType() ? ".server" : "") + ".toml");
        }
    }

    public static void loadConfigs(Class<?> configClass) {
        UnionConfig con = configClass.getAnnotation(UnionConfig.class);
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.CLIENT)) {
            ConfigBuilder.loadConfig(client_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? ".client" : "") + ".toml");
        }
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.COMMON)) {
            ConfigBuilder.loadConfig(common_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? ".common" : "") + ".toml");
        }
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.SERVER)) {
            ConfigBuilder.loadConfig(server_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? ".server" : "") + ".toml");
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfig.ModConfigEvent event) {
        ConfigBuilder.reload();
        System.out.println("From the event itself");
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading event) {
        ConfigBuilder.reload();
    }

    public static void reload() {
        for (Class<?> configClass : configs) {
            UnionConfig con = configClass.getAnnotation(UnionConfig.class);
            if (!con.autoReload()) continue;
            ConfigBuilder.read(configClass);
            System.out.println("Detected change in " + con.name() + "'s config file. Reloading values");
        }
    }

    public static void load() {
        System.out.println("Loading all values from the config files into their respective configuration variables");
        for (Class<?> configClass : configs) {
            UnionConfig con = configClass.getAnnotation(UnionConfig.class);
            ConfigBuilder.read(configClass);
            System.out.println("Loading " + con.name() + "'s config");
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        ConfigBuilder.load();
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    public static class Holder {
        protected final ForgeConfigSpec.ConfigValue<?> value;
        protected final List<ITextComponent> comments;
        protected final boolean usesSider;
        protected final double min;
        protected final double max;

        public Holder(ForgeConfigSpec.ConfigValue<?> configvalue, List<ITextComponent> comments, boolean usesSider, double min, double max) {
            this.comments = comments;
            this.value = configvalue;
            this.usesSider = usesSider;
            this.min = min;
            this.max = max;
        }

        public ForgeConfigSpec.ConfigValue<?> getValue() {
            return this.value;
        }

        public List<ITextComponent> getComments() {
            return this.comments;
        }

        public boolean isUsesSider() {
            return this.usesSider;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }
}

