/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.event;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.inventory.UnionInventory;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BaseGameEvents {
    @SubscribeEvent
    public static void loadInventory(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            UnionInventory unionInventory = UnionLib.getAccessoryInventory((PlayerEntity)player);
            unionInventory.tick();
            if (!player.getPersistentData().func_74764_b("UnionInventory")) {
                UnionLib.saveInventory((PlayerEntity)player, unionInventory);
            }
        }
    }

    @SubscribeEvent
    public static void dropInventoryItems(LootingLevelEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            BaseGameEvents.dropInventory((PlayerEntity)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        UnionInventory newUnionInventory = UnionLib.getAccessoryInventory(event.getPlayer());
        UnionInventory originalUnionInventory = UnionLib.getAccessoryInventory(event.getOriginal());
        if (!event.isWasDeath()) {
            newUnionInventory.copyInventory(originalUnionInventory);
        } else if (event.getPlayer().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || event.getOriginal().func_175149_v()) {
            newUnionInventory.copyInventory(originalUnionInventory);
        }
        UnionLib.saveInventory(event.getPlayer(), newUnionInventory);
        UnionLib.saveInventory(event.getOriginal(), originalUnionInventory);
    }

    protected static void dropInventory(PlayerEntity player) {
        UnionInventory unionInventory = UnionLib.getAccessoryInventory(player);
        if (!player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            BaseGameEvents.destroyVanishingCursedItems(player);
            unionInventory.dropAllItems();
        }
    }

    protected static void destroyVanishingCursedItems(PlayerEntity player) {
        UnionInventory unionInventory = UnionLib.getAccessoryInventory(player);
        for (int i = 0; i < unionInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = unionInventory.func_70301_a(i);
            if (itemstack.func_190926_b() || !EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
            unionInventory.func_70304_b(i);
        }
    }
}

