/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mod;

import com.stereowalker.unionlib.UnionLib;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class UnionMod {
    private String modid;
    private LoadType loadType;
    private ResourceLocation modTexture;
    private ModInfo modInfo;
    private final String NETWORK_PROTOCOL_VERSION = "1";
    public final SimpleChannel channel;
    private int netID = -1;

    public UnionMod(String modid, ResourceLocation modTexture, LoadType loadType, boolean shouldLoadMod) {
        this.modid = modid;
        this.modTexture = modTexture;
        this.loadType = loadType;
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)this.location("main_simple_channel"), () -> "1", "1"::equals, "1"::equals);
        if (shouldLoadMod) {
            UnionLib.mods.add(this);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (minecraft, parentScreen) -> this.getConfigScreen((Minecraft)minecraft, (Screen)parentScreen));
            this.registerMessages(this.channel);
        }
    }

    public UnionMod(String modid, ResourceLocation modTexture, LoadType loadType) {
        this(modid, modTexture, loadType, true);
    }

    public LoadType getLoadType() {
        return this.loadType;
    }

    public String getModid() {
        return this.modid;
    }

    public Logger getLogger() {
        return LogManager.getLogger((String)this.modid);
    }

    public ResourceLocation getModTexture() {
        return this.modTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
        return null;
    }

    public ResourceLocation location(String name) {
        return new ResourceLocation(this.modid, name);
    }

    public String locationString(String name) {
        return this.modid + ":" + name;
    }

    public void registerMessages(SimpleChannel channel) {
    }

    public ModInfo getModInfo() {
        ModList.get().getMods().forEach(mod -> {
            if (mod.getModId() == this.getModid()) {
                this.modInfo = mod;
            }
        });
        return this.modInfo;
    }

    public String getVersion() {
        if (this.getModInfo() != null) {
            return MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)this.getModInfo().getVersion());
        }
        return "???";
    }

    public static enum LoadType {
        CLIENT,
        BOTH,
        SERVER;

    }
}

