/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.api;

import com.google.common.collect.Multimap;
import com.google.gson.annotations.SerializedName;
import draylar.tiered.Tiered;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeTemplate {
    @SerializedName(value="type")
    private final String attributeTypeID;
    @SerializedName(value="modifier")
    private final AttributeModifier attributeModifier;
    @SerializedName(value="required_equipment_slots")
    private final EquipmentSlot[] requiredEquipmentSlotTypes;
    @SerializedName(value="optional_equipment_slots")
    private final EquipmentSlot[] optionalEquipmentSlotTypes;

    public AttributeTemplate(String attributeTypeID, AttributeModifier AttributeModifier2, EquipmentSlot[] requiredEquipmentSlotTypes, EquipmentSlot[] optionalEquipmentSlotTypes) {
        this.attributeTypeID = attributeTypeID;
        this.attributeModifier = AttributeModifier2;
        this.requiredEquipmentSlotTypes = requiredEquipmentSlotTypes;
        this.optionalEquipmentSlotTypes = optionalEquipmentSlotTypes;
    }

    public EquipmentSlot[] getRequiredEquipmentSlot() {
        return this.requiredEquipmentSlotTypes;
    }

    public EquipmentSlot[] getOptionalEquipmentSlot() {
        return this.optionalEquipmentSlotTypes;
    }

    public void realize(Multimap<Attribute, AttributeModifier> multimap, EquipmentSlot slot) {
        AttributeModifier cloneModifier = new AttributeModifier(Tiered.MODIFIERS[slot.m_20750_()], this.attributeModifier.m_22214_() + "_" + slot.m_20751_(), this.attributeModifier.m_22218_(), this.attributeModifier.m_22217_());
        Attribute key = (Attribute)Registry.f_122866_.m_7745_(new ResourceLocation(this.attributeTypeID));
        if (key == null) {
            Tiered.LOGGER.warn(String.format("%s was referenced as an attribute type, but it does not exist! A data file in /tiered/item_attributes/ has an invalid type property.", this.attributeTypeID));
        } else {
            multimap.put((Object)key, (Object)cloneModifier);
        }
    }
}

