/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.mixin;

import com.mojang.authlib.GameProfile;
import draylar.tiered.api.ModifierUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player {
    private NonNullList<ItemStack> mainCopy = null;

    private ServerPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.mainCopy == null) {
            this.mainCopy = this.copyDefaultedList((NonNullList<ItemStack>)this.f_36093_.f_35974_);
            this.runCheck();
        }
        if (!this.f_36093_.f_35974_.equals(this.mainCopy)) {
            this.mainCopy = this.copyDefaultedList((NonNullList<ItemStack>)this.f_36093_.f_35974_);
            this.runCheck();
        }
    }

    @Unique
    private NonNullList<ItemStack> copyDefaultedList(NonNullList<ItemStack> list) {
        NonNullList newList = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            newList.set(i, (Object)((ItemStack)list.get(i)));
        }
        return newList;
    }

    @Unique
    private void runCheck() {
        this.f_36093_.f_35974_.forEach(itemStack -> {
            ResourceLocation potentialAttributeID;
            if (itemStack.m_41737_("Tiered") == null && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(itemStack.m_41720_())) != null) {
                itemStack.m_41698_("Tiered").m_128359_("Tier", potentialAttributeID.toString());
            }
        });
    }
}

