/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.network;

import draylar.tiered.Tiered;
import draylar.tiered.api.PotentialAttribute;
import draylar.tiered.data.AttributeDataLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class AttributeSyncer {
    public int size = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().size();
    public Map<ResourceLocation, PotentialAttribute> attribute = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes();
    public static final Map<ResourceLocation, PotentialAttribute> CACHED_ATTRIBUTES = new HashMap<ResourceLocation, PotentialAttribute>();

    public static AttributeSyncer decode(FriendlyByteBuf buf) {
        AttributeSyncer packet = new AttributeSyncer();
        packet.size = buf.readInt();
        for (int i = 0; i < packet.size; ++i) {
            ResourceLocation id = new ResourceLocation(buf.m_130277_());
            PotentialAttribute pa = (PotentialAttribute)AttributeDataLoader.GSON.fromJson(buf.m_130277_(), PotentialAttribute.class);
            packet.attribute.put(id, pa);
        }
        return packet;
    }

    public static void encode(AttributeSyncer packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.size);
        packet.attribute.forEach((id, attribute) -> {
            buf.m_130070_(id.toString());
            buf.m_130070_(AttributeDataLoader.GSON.toJson(attribute));
        });
    }

    public static void handlePacket(AttributeSyncer packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                CACHED_ATTRIBUTES.putAll(Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes());
                Tiered.ATTRIBUTE_DATA_LOADER.clear();
                Tiered.ATTRIBUTE_DATA_LOADER.replace(packet.attribute);
                if (Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().size() == 0) {
                    Tiered.ATTRIBUTE_DATA_LOADER.replace(CACHED_ATTRIBUTES);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

