/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientCape {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final Logger logger = LogManager.getLogger((String)"unionlib");
    private static final JsonParser parser = new JsonParser();
    private static final Map<UUID, String> CAPES_LOCATION = Maps.newHashMap();

    public static void loadCapes() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/Stereowalker/UnionLib/1.16-forge/capes.json");
            URLConnection connection = url.openConnection();
            connection.connect();
            System.out.println("Found the cape Json file on GitHub");
            BufferedReader read = new BufferedReader(new InputStreamReader(url.openStream()));
            JsonObject object = parser.parse((Reader)read).getAsJsonObject();
            for (Map.Entry element : object.entrySet()) {
                System.out.println("Found cape for " + (String)element.getKey() + " they seem to want to use the " + ((JsonElement)element.getValue()).getAsString() + " cape");
                CAPES_LOCATION.put(UUID.fromString((String)element.getKey()), ((JsonElement)element.getValue()).getAsString());
            }
            read.close();
        }
        catch (MalformedURLException e) {
            System.out.println("Internet is not connected");
        }
        catch (IOException e) {
            System.out.println("Internet is not connected");
        }
    }

    public static void queuePlayerCapeReplacement(AbstractClientPlayer player) {
        String displayName = player.m_5446_().getString();
        logger.info("Queueing cape replacement for " + displayName);
        THREAD_POOL.submit(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.fatal("Cape delay thread for " + displayName + " interrupted");
                return;
            }
            Minecraft.m_91087_().m_18689_(() -> ClientCape.replacePlayerCape(player));
        });
    }

    private static void replacePlayerCape(AbstractClientPlayer player) {
        String displayName = player.m_5446_().getString();
        PlayerInfo playerInfo = player.m_108558_();
        if (playerInfo == null) {
            logger.info("PlayerInfo of " + displayName + " is null. Cannot add cape");
            return;
        }
        Map playerTextures = playerInfo.f_105299_;
        playerTextures.put(MinecraftProfileTexture.Type.CAPE, new ResourceLocation("unionlib", "textures/cape/" + CAPES_LOCATION.get(Player.m_36198_((GameProfile)player.m_36316_())) + ".png"));
        logger.info("Looking for cape texture at " + new ResourceLocation("unionlib", "textures/cape/" + CAPES_LOCATION.get(Player.m_36198_((GameProfile)player.m_36316_())) + ".png").m_135815_());
        logger.info("Replaced cape of " + displayName);
    }

    public static boolean doesPlayerNeedCapeClient(AbstractClientPlayer player) {
        return CAPES_LOCATION.containsKey(Player.m_36198_((GameProfile)player.m_36316_()));
    }
}

