/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.stereowalker.unionlib.ClientCape;
import com.stereowalker.unionlib.client.gui.screen.inventory.UScreens;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.config.MinecraftModConfigsScreen;
import com.stereowalker.unionlib.client.keybindings.KeyBindings;
import com.stereowalker.unionlib.config.Config;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ServerConfig;
import com.stereowalker.unionlib.config.tests.TestBindClass1Config;
import com.stereowalker.unionlib.config.tests.TestBindClass2Config;
import com.stereowalker.unionlib.config.tests.TestClassConfig;
import com.stereowalker.unionlib.config.tests.TestObjectConfig;
import com.stereowalker.unionlib.entity.ai.UAttributes;
import com.stereowalker.unionlib.inventory.UnionInventory;
import com.stereowalker.unionlib.item.UItems;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.network.PacketRegistry;
import com.stereowalker.unionlib.registries.RegisterObjects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fmlclient.registry.ClientRegistry;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="unionlib")
public class UnionLib {
    public static UnionLib instance;
    public static TestObjectConfig test_config;
    public static final Config CONFIG;
    public static final ServerConfig SERVER_CONFIG;
    public static final String MOD_ID = "unionlib";
    public static final Logger LOGGER;
    public static final String INVENTORY_KEY = "UnionInventory";
    private static final String NETWORK_PROTOCOL_VERSION = "1";
    public static boolean debugMode;
    public static List<MinecraftMod> mods;
    public static MinecraftMod.LoadType loadLevel;
    public static final SimpleChannel CHANNEL;

    public static void debug(String message) {
        if (debugMode) {
            LOGGER.debug(message);
        }
    }

    public static void warn(String message) {
        if (debugMode) {
            LOGGER.warn(message);
        }
    }

    public static boolean disableConfig() {
        return false;
    }

    public UnionLib() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigBuilder.registerConfig(CONFIG);
        ConfigBuilder.registerConfig(SERVER_CONFIG);
        if (!FMLEnvironment.production) {
            ConfigBuilder.registerConfig(TestClassConfig.class);
            ConfigBuilder.registerConfig(TestBindClass1Config.class);
            ConfigBuilder.registerConfig(TestBindClass2Config.class);
            ConfigBuilder.registerConfig(test_config);
        }
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        UAttributes.registerAll(modEventBus);
        PacketRegistry.registerMessages(CHANNEL);
        ClientCape.loadCapes();
        new MinecraftMod(MOD_ID, UnionLib.location("textures/gui/union_button.png"), MinecraftMod.LoadType.BOTH){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new ConfigScreen(previousScreen, CONFIG, (Component)new TranslatableComponent("UnionLib Config"));
            }

            @Override
            public List<Class<?>> getRegistries() {
                return Lists.newArrayList((Object[])new Class[]{UItems.class});
            }

            @Override
            public KeyMapping[] getModKeyMappings() {
                return new KeyMapping[]{KeyBindings.OPEN_UNION_INVENTORY};
            }
        };
        new MinecraftMod("concept_class", UnionLib.location("textures/gui/test_1.png"), MinecraftMod.LoadType.CLIENT, !FMLEnvironment.production){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new ConfigScreen(previousScreen, TestClassConfig.class, (Component)new TranslatableComponent("Test Config 1"));
            }
        };
        new MinecraftMod("concept_object", UnionLib.location("textures/gui/test_2.png"), MinecraftMod.LoadType.CLIENT, !FMLEnvironment.production){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new ConfigScreen(previousScreen, test_config, (Component)new TranslatableComponent("Test Config 2"));
            }
        };
        new MinecraftMod("concept_combined_config", UnionLib.location("textures/gui/test_3.png"), MinecraftMod.LoadType.CLIENT, !FMLEnvironment.production){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new MinecraftModConfigsScreen(previousScreen, (Component)new TranslatableComponent("Test Config 3"), TestBindClass1Config.class, TestBindClass2Config.class);
            }
        };
        new MinecraftMod("concept_keys", UnionLib.location("textures/gui/test_4.png"), MinecraftMod.LoadType.CLIENT, !FMLEnvironment.production){

            @Override
            public KeyMapping[] getModKeyMappings() {
                return new KeyMapping[]{new KeyMapping("key.unionlib.test_bind", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "DAD")};
            }
        };
        boolean setupLoadLevel = false;
        for (MinecraftMod mod : mods) {
            if (!setupLoadLevel) {
                if (mod.getLoadType() == MinecraftMod.LoadType.BOTH) {
                    loadLevel = MinecraftMod.LoadType.BOTH;
                    setupLoadLevel = true;
                } else if (mod.getLoadType() == MinecraftMod.LoadType.CLIENT) {
                    if (loadLevel == MinecraftMod.LoadType.SERVER) {
                        loadLevel = MinecraftMod.LoadType.BOTH;
                        setupLoadLevel = true;
                    } else {
                        loadLevel = MinecraftMod.LoadType.CLIENT;
                    }
                } else if (mod.getLoadType() == MinecraftMod.LoadType.SERVER) {
                    if (loadLevel == MinecraftMod.LoadType.CLIENT) {
                        loadLevel = MinecraftMod.LoadType.BOTH;
                        setupLoadLevel = true;
                    } else {
                        loadLevel = MinecraftMod.LoadType.SERVER;
                    }
                }
            }
            for (Class<?> clas : mod.getRegistries()) {
                RegisterObjects.register(clas);
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        if (loadLevel != MinecraftMod.LoadType.CLIENT) {
            mods.forEach(mod -> Lists.newArrayList((Object[])mod.getModKeyMappings()).forEach(ClientRegistry::registerKeyBinding));
            UScreens.registerScreens();
        }
    }

    public static ResourceLocation location(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static UnionInventory getAccessoryInventory(Player player) {
        UnionInventory inventory = new UnionInventory(player);
        inventory.read(player.getPersistentData().m_128437_(INVENTORY_KEY, 10));
        return inventory;
    }

    public static void saveInventory(Player player, UnionInventory inventory) {
        player.getPersistentData().m_128365_(INVENTORY_KEY, (Tag)inventory.write());
    }

    static {
        test_config = new TestObjectConfig();
        CONFIG = new Config();
        SERVER_CONFIG = new ServerConfig();
        LOGGER = LogManager.getLogger((String)MOD_ID);
        debugMode = false;
        mods = new ArrayList<MinecraftMod>();
        loadLevel = null;
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)UnionLib.location("main"), () -> NETWORK_PROTOCOL_VERSION, NETWORK_PROTOCOL_VERSION::equals, NETWORK_PROTOCOL_VERSION::equals);
    }
}

