/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.client.gui.screens.ModConfigurationScreen;
import com.stereowalker.unionlib.client.gui.screens.UnionModsScreen;
import com.stereowalker.unionlib.client.gui.screens.controls.ModControlsScreen;
import com.stereowalker.unionlib.client.gui.widget.button.OverlayImageButton;
import com.stereowalker.unionlib.mod.MinecraftMod;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModList
extends ContainerObjectSelectionList<Entry> {
    public ModList(Minecraft mcIn, UnionModsScreen screen) {
        super(mcIn, screen.f_96543_ + 45, screen.f_96544_, 43, screen.f_96544_ - 32, 25);
        for (MinecraftMod mod : UnionLib.mods) {
            this.m_7085_((AbstractSelectionList.Entry)new ModEntry(mod, screen));
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 40;
    }

    public int m_5759_() {
        return super.m_5759_() + 72;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ModEntry
    extends Entry {
        private final MinecraftMod mod;
        private final Screen screen;
        private final Button modImage;
        private final Button configButton;
        private final boolean noConfig;

        private ModEntry(MinecraftMod mod, Screen screen) {
            this.mod = mod;
            this.screen = screen;
            this.modImage = new OverlayImageButton(0, 0, 20, 20, 0, 0, 20, mod.getModTexture(), 20, 40, onPress -> {}, (Component)new TranslatableComponent("menu.button.union"));
            if (this.mod.getConfigScreen(ModList.this.f_93386_, this.screen) != null && this.mod.getModKeyMappings().length <= 0) {
                this.configButton = new Button(0, 0, 200, 20, (Component)new TranslatableComponent("union.gui.config"), onPress -> ModList.this.f_93386_.m_91152_(mod.getConfigScreen(ModList.this.f_93386_, this.screen)));
                this.noConfig = false;
            } else if (this.mod.getModKeyMappings().length > 0 && this.mod.getConfigScreen(ModList.this.f_93386_, this.screen) == null) {
                this.configButton = new Button(0, 0, 200, 20, (Component)new TranslatableComponent("union.gui.controls"), onPress -> ModList.this.f_93386_.m_91152_((Screen)new ModControlsScreen(mod, this.screen, screen.getMinecraft().f_91066_)));
                this.noConfig = false;
            } else if (this.mod.getModKeyMappings().length > 0 && this.mod.getConfigScreen(ModList.this.f_93386_, this.screen) != null) {
                this.configButton = new Button(0, 0, 200, 20, (Component)new TranslatableComponent("union.gui.setup"), onPress -> ModList.this.f_93386_.m_91152_((Screen)new ModConfigurationScreen(mod, screen)));
                this.noConfig = false;
            } else {
                this.configButton = new Button(0, 0, 200, 20, (Component)new TranslatableComponent("union.gui.controls"), onPress -> {});
                this.noConfig = true;
            }
        }

        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            this.modImage.f_93620_ = p_230432_4_;
            this.modImage.f_93621_ = p_230432_3_;
            this.modImage.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            this.configButton.f_93620_ = p_230432_4_ + 50;
            this.configButton.f_93621_ = p_230432_3_;
            this.configButton.f_93623_ = !this.noConfig;
            this.configButton.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.modImage, (Object)this.configButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.modImage, (Object)this.configButton);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.modImage.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return this.configButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.modImage.m_6348_(mouseX, mouseY, button) || this.configButton.m_6348_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

