/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.stereowalker.unionlib.client.gui.components.OverflowTextButton;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.widget.button.Slider;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ConfigList
extends ContainerObjectSelectionList<Entry> {
    protected ConfigScreen screen;
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    public ConfigList(Minecraft mcIn, ConfigScreen screen, UnionConfig config) {
        super(mcIn, screen.f_96543_ + 45, screen.f_96544_, 43, screen.f_96544_ - 32, 25);
        this.screen = screen;
        List<String> c = Arrays.asList(ConfigBuilder.getValues(config).keySet().toArray(new String[0]));
        Collections.sort(c);
        String currentCategory = "";
        for (String configValue : c) {
            Object name = "";
            for (int i = 1; i < configValue.split("=").length; ++i) {
                name = (String)name + configValue.split("=")[i];
            }
            if (ConfigList.split((String)name).size() > 1 && !ConfigList.split((String)name).get(0).equals(currentCategory)) {
                this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)new TranslatableComponent(ConfigList.split((String)name).get(0))));
                currentCategory = ConfigList.split((String)name).get(0);
            }
            Object name2 = "";
            if (ConfigList.split((String)name).size() > 1) {
                for (int i = 1; i < ConfigList.split((String)name).size(); ++i) {
                    name2 = (String)name2 + ConfigList.split((String)name).get(i);
                }
            } else {
                name2 = name;
            }
            ConfigBuilder.Holder holder = ConfigBuilder.getValues(config).get(configValue);
            boolean usesSlider = ConfigBuilder.getValues(config).get(configValue).isUsesSider();
            List<Component> comment = ConfigBuilder.getValues(config).get(configValue).getComments();
            if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Boolean) {
                this.m_7085_((AbstractSelectionList.Entry)new BooleanEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue()));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof String) {
                this.m_7085_((AbstractSelectionList.Entry)new StringEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue()));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Enum) {
                this.m_7085_((AbstractSelectionList.Entry)new EnumEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue()));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Number) {
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Double) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Float) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Long) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Short) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getValue().get() instanceof Byte) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                    continue;
                }
                this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry((Component)new TranslatableComponent((String)name2), comment, ConfigBuilder.getValues(config).get(configValue).getValue(), usesSlider, holder.getMin(), holder.getMax()));
                continue;
            }
            this.m_7085_((AbstractSelectionList.Entry)new ConfigEntry((Component)new TranslatableComponent((String)name2), ConfigBuilder.getValues(config).get(configValue).getComments(), ConfigBuilder.getValues(config).get(configValue).getValue()));
        }
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 40;
    }

    public int m_5759_() {
        return super.m_5759_() + 72;
    }

    public void tick() {
        for (Entry ent : this.m_6702_()) {
            if (!(ent instanceof ConfigEntry)) continue;
            ((ConfigEntry)ent).tick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        private final Component labelText;
        private final int labelWidth;

        public CategoryEntry(Component p_i232280_2_) {
            this.labelText = p_i232280_2_;
            this.labelWidth = ((ConfigList)ConfigList.this).f_93386_.f_91062_.m_92852_((FormattedText)this.labelText);
        }

        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ((ConfigList)ConfigList.this).f_93386_.f_91062_.m_92889_(p_230432_1_, this.labelText, (float)(((ConfigList)ConfigList.this).f_93386_.f_91080_.f_96543_ / 2 - this.labelWidth / 2), (float)(p_230432_3_ + p_230432_6_ - 9 - 1), 0xFFFFFF);
        }

        public boolean m_5755_(boolean focus) {
            return false;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BooleanEntry
    extends ConfigEntry<Boolean> {
        private final Button booleanButton;

        private BooleanEntry(Component name, List<Component> comment, ForgeConfigSpec.ConfigValue<Boolean> config) {
            super(name, comment, config);
            this.booleanButton = new Button(0, 0, 200, 20, name, onPress -> {
                config.set((Object)((Boolean)config.get() == false ? 1 : 0));
                ConfigBuilder.reload();
            });
        }

        @Override
        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.m_6311_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.booleanButton.f_93620_ = p_230432_4_ + 130;
            this.booleanButton.f_93621_ = p_230432_3_;
            this.booleanButton.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            this.booleanButton.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)this.config.get())));
        }

        public List<? extends GuiEventListener> getEventListeners() {
            return ImmutableList.of((Object)this.booleanButton);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.booleanButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.booleanButton.m_6348_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class StringEntry
    extends ConfigEntry<String> {
        private final EditBox stringField;

        private StringEntry(Component name, List<Component> comment, ForgeConfigSpec.ConfigValue<String> config) {
            super(name, comment, config);
            this.stringField = new EditBox(((ConfigList)ConfigList.this).f_93386_.f_91062_, 0, 0, 200, 20, (Component)new TranslatableComponent("config.editBox"));
            this.stringField.m_94144_((String)this.config.get());
            this.stringField.m_94151_(p_214319_1_ -> {
                this.config.set(p_214319_1_);
                ConfigBuilder.reload();
            });
            ConfigList.this.screen.addChild(this.stringField);
        }

        @Override
        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.m_6311_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.stringField.f_93620_ = p_230432_4_ + 130;
            this.stringField.f_93621_ = p_230432_3_;
            this.stringField.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        @Override
        public void tick() {
            this.stringField.m_94120_();
            super.tick();
        }

        public List<? extends GuiEventListener> getEventListeners() {
            return ImmutableList.of((Object)this.stringField);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.stringField.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.stringField.m_6348_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EnumEntry
    extends ConfigEntry<Enum<?>> {
        private final Button enumButton;

        private EnumEntry(Component name, List<Component> comment, ForgeConfigSpec.ConfigValue<Enum<?>> config) {
            super(name, comment, config);
            this.enumButton = new Button(0, 0, 200, 20, name, onPress -> {
                config.set((Object)RegistryHelper.rotateEnumForward((Enum)((Enum)config.get()), (Enum[])((Enum[])((Enum)config.get()).getDeclaringClass().getEnumConstants())));
                ConfigBuilder.reload();
            });
        }

        @Override
        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.m_6311_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.enumButton.f_93620_ = p_230432_4_ + 130;
            this.enumButton.f_93621_ = p_230432_3_;
            this.enumButton.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            this.enumButton.m_93666_((Component)new TranslatableComponent(((Enum)this.config.get()).name()));
        }

        public List<? extends GuiEventListener> getEventListeners() {
            return ImmutableList.of((Object)this.enumButton);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.enumButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.enumButton.m_6348_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class NumberedEntry<V extends Number>
    extends ConfigEntry<V> {
        private final EditBox stringField;
        private final Slider slider;
        private final boolean useSlider;

        private NumberedEntry(Component name, List<Component> comment, final ForgeConfigSpec.ConfigValue<V> config, boolean useSlider, final double min, double max) {
            super(name, comment, config);
            this.useSlider = useSlider;
            final double shiftedMax = max - min;
            this.slider = new Slider(0, 0, 200, 20, ((Number)config.get()).doubleValue() / shiftedMax, (Component)new TextComponent(((Number)config.get()).toString())){

                @Override
                protected void m_5697_() {
                    if (NumberedEntry.this.useSlider) {
                        Number oldValue = (Number)config.get();
                        Double newValue = this.f_93577_ * shiftedMax + min;
                        try {
                            if (config.get() instanceof Double) {
                                NumberedEntry.this.config.set((Object)newValue);
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Float) {
                                NumberedEntry.this.config.set((Object)Float.valueOf(newValue.floatValue()));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Long) {
                                NumberedEntry.this.config.set((Object)newValue.longValue());
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Short) {
                                NumberedEntry.this.config.set((Object)newValue.shortValue());
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Byte) {
                                NumberedEntry.this.config.set((Object)newValue.byteValue());
                                ConfigBuilder.reload();
                            } else {
                                NumberedEntry.this.config.set((Object)newValue.intValue());
                                ConfigBuilder.reload();
                            }
                        }
                        catch (NumberFormatException e) {
                            config.set((Object)oldValue);
                            ConfigBuilder.reload();
                        }
                        this.m_93666_((Component)new TextComponent(((Number)NumberedEntry.this.config.get()).toString()));
                    }
                }
            };
            this.stringField = new EditBox(((ConfigList)ConfigList.this).f_93386_.f_91062_, 0, 0, 200, 20, (Component)new TranslatableComponent("config.editNumber")){

                public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                    if (keyCode == 257) {
                        this.updateValues();
                    }
                    return super.m_7933_(keyCode, scanCode, modifiers);
                }

                protected void m_7207_(boolean focused) {
                    super.m_7207_(focused);
                }

                public void m_94120_() {
                    if (!this.m_93696_() && !this.m_94155_().equals(((Number)config.get()).toString())) {
                        this.updateValues();
                    }
                    super.m_94120_();
                }

                public void updateValues() {
                    if (!NumberedEntry.this.useSlider) {
                        Number oldValue = (Number)config.get();
                        try {
                            if (config.get() instanceof Double) {
                                NumberedEntry.this.config.set((Object)Double.parseDouble(this.m_94155_()));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Float) {
                                NumberedEntry.this.config.set((Object)Float.valueOf(Float.parseFloat(this.m_94155_())));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Long) {
                                NumberedEntry.this.config.set((Object)Long.parseLong(this.m_94155_()));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Short) {
                                NumberedEntry.this.config.set((Object)Short.parseShort(this.m_94155_()));
                                ConfigBuilder.reload();
                            } else if (config.get() instanceof Byte) {
                                NumberedEntry.this.config.set((Object)Byte.parseByte(this.m_94155_()));
                                ConfigBuilder.reload();
                            } else {
                                NumberedEntry.this.config.set((Object)Integer.parseInt(this.m_94155_()));
                                ConfigBuilder.reload();
                            }
                        }
                        catch (NumberFormatException e) {
                            config.set((Object)oldValue);
                            ConfigBuilder.reload();
                            this.m_94144_(oldValue.toString());
                        }
                    }
                }
            };
            this.stringField.m_94144_(((Number)this.config.get()).toString());
            ConfigList.this.screen.addChild(this.stringField);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return this.stringField.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return this.slider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        @Override
        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.m_6311_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            if (this.useSlider) {
                this.slider.f_93620_ = p_230432_4_ + 130;
                this.slider.f_93621_ = p_230432_3_;
                this.slider.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            } else {
                this.stringField.f_93620_ = p_230432_4_ + 130;
                this.stringField.f_93621_ = p_230432_3_;
                this.stringField.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            }
        }

        @Override
        public void tick() {
            this.stringField.m_94120_();
            super.tick();
        }

        public List<? extends GuiEventListener> getEventListeners() {
            return ImmutableList.of((Object)this.stringField, (Object)((Object)this.slider));
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.slider.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return this.stringField.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.stringField.m_6348_(mouseX, mouseY, button) || this.slider.m_6348_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ConfigEntry<T>
    extends Entry {
        protected final ForgeConfigSpec.ConfigValue<T> config;
        protected final Button configButton;

        public void tick() {
        }

        private ConfigEntry(Component name, List<Component> comment, ForgeConfigSpec.ConfigValue<T> config) {
            this.config = config;
            this.configButton = new OverflowTextButton(0, 0, 200, 20, name, onPress -> {}, (button, stack, x, y) -> {
                int space = ((ConfigList)ConfigList.this).f_93386_.f_91080_.f_96544_ - y;
                int textHeight = comment.size();
                int drawY = y;
                if (textHeight * 15 > space) {
                    drawY -= textHeight * 15 - space;
                }
                if (comment != null) {
                    ((ConfigList)ConfigList.this).f_93386_.f_91080_.m_96597_(stack, comment, x, drawY);
                }
            });
        }

        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            this.configButton.f_93620_ = p_230432_4_ - 90;
            this.configButton.f_93621_ = p_230432_3_;
            this.configButton.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            this.configButton.f_93623_ = false;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.configButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.configButton);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

