/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.stereowalker.unionlib.config.ConfigClassBuilder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.config.ConfigObjectBuilder;
import com.stereowalker.unionlib.config.UnionConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class ConfigBuilder {
    static Map<String, Holder> client_values = new HashMap<String, Holder>();
    static Map<String, Holder> common_values = new HashMap<String, Holder>();
    static Map<String, Holder> server_values = new HashMap<String, Holder>();
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    static Map<String, Holder> retrieveValues(ModConfig.Type ... types) {
        HashMap<String, Holder> values = new HashMap<String, Holder>();
        boolean hasClient = false;
        boolean hasCommon = false;
        boolean hasServer = false;
        for (ModConfig.Type type : types) {
            if (type == ModConfig.Type.CLIENT && !hasClient) {
                hasClient = true;
                values.putAll(client_values);
            }
            if (type == ModConfig.Type.COMMON && !hasCommon) {
                hasCommon = true;
                values.putAll(common_values);
            }
            if (type != ModConfig.Type.SERVER || hasServer) continue;
            hasServer = true;
            values.putAll(server_values);
        }
        return values;
    }

    static void putValue(ModConfig.Type type, String key, Holder value) {
        if (type == ModConfig.Type.CLIENT) {
            client_values.put(key, value);
        }
        if (type == ModConfig.Type.COMMON) {
            common_values.put(key, value);
        }
        if (type == ModConfig.Type.SERVER) {
            server_values.put(key, value);
        }
    }

    public static String configName(UnionConfig.Entry configEntry, String dataType) {
        if (configEntry.group().isEmpty()) {
            if (!dataType.isEmpty()) {
                return dataType + ": " + configEntry.name();
            }
            return configEntry.name();
        }
        if (!dataType.isEmpty()) {
            return configEntry.group() + "." + dataType + ": " + configEntry.name();
        }
        return configEntry.group() + "." + configEntry.name();
    }

    public static String configName(UnionConfig.Entry configEntry) {
        return ConfigBuilder.configName(configEntry, "");
    }

    static ForgeConfigSpec.ConfigValue<?> getConfigValue(UnionConfig config, UnionConfig.Entry configEntry) {
        if (config != null && configEntry != null) {
            return ConfigBuilder.retrieveValues(ModConfig.Type.CLIENT, ModConfig.Type.COMMON, ModConfig.Type.SERVER).getOrDefault(config.name() + "=" + ConfigBuilder.configName(configEntry), new Holder(new ForgeConfigSpec.Builder().define("empty", (Object)"nothing_was_found"), null, false, 0.0, 0.0)).getValue();
        }
        return null;
    }

    public static Map<String, Holder> getValues(UnionConfig config) {
        HashMap<String, Holder> values2 = new HashMap<String, Holder>();
        for (String configValue : ConfigBuilder.retrieveValues(ModConfig.Type.CLIENT, ModConfig.Type.COMMON, ModConfig.Type.SERVER).keySet()) {
            if (!configValue.split("=")[0].equals(config.name())) continue;
            values2.put(configValue, ConfigBuilder.retrieveValues(ModConfig.Type.CLIENT, ModConfig.Type.COMMON, ModConfig.Type.SERVER).get(configValue));
        }
        return values2;
    }

    public static void registerConfig(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class) && !ConfigClassBuilder.configs.contains(configClass)) {
            UnionConfig con = configClass.getAnnotation(UnionConfig.class);
            System.out.println("Registered the config for " + con.name());
            ConfigClassBuilder.configs.add(configClass);
            ConfigClassBuilder.client_builder.put(configClass, new ForgeConfigSpec.Builder());
            ConfigClassBuilder.common_builder.put(configClass, new ForgeConfigSpec.Builder());
            ConfigClassBuilder.server_builder.put(configClass, new ForgeConfigSpec.Builder());
            ConfigClassBuilder.registerConfigurations(configClass);
            ConfigClassBuilder.loadConfigs(configClass);
            ConfigClassBuilder.read(configClass, new ModConfig.Type[0]);
        } else {
            if (!configClass.isAnnotationPresent(UnionConfig.class)) {
                throw new RuntimeException("You cannot register a config if it does not have the UnionConfig annotation");
            }
            if (ConfigClassBuilder.configs.contains(configClass)) {
                throw new RuntimeException("This config class has already been regtistered");
            }
        }
    }

    public static void registerConfig(ConfigObject configObject) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class) && !ConfigObjectBuilder.configs.contains(configObject)) {
            UnionConfig con = configObject.getClass().getAnnotation(UnionConfig.class);
            System.out.println("Registered the config for " + con.name());
            ConfigObjectBuilder.configs.add(configObject);
            ConfigObjectBuilder.client_builder.put(configObject, new ForgeConfigSpec.Builder());
            ConfigObjectBuilder.common_builder.put(configObject, new ForgeConfigSpec.Builder());
            ConfigObjectBuilder.server_builder.put(configObject, new ForgeConfigSpec.Builder());
            ConfigObjectBuilder.registerConfigurations(configObject);
            ConfigObjectBuilder.loadConfigs(configObject);
            ConfigObjectBuilder.read(configObject, new ModConfig.Type[0]);
        } else {
            if (!configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
                throw new RuntimeException("You cannot register a config if it does not have the UnionConfig annotation");
            }
            if (ConfigObjectBuilder.configs.contains(configObject)) {
                throw new RuntimeException("This config object has already been regtistered");
            }
        }
    }

    public static void loadConfig(ForgeConfigSpec config, String path, String fileName) {
        File configFile = new File(path, fileName);
        configFile.getParentFile().mkdirs();
        System.out.println(path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)configFile).sync().autosave().preserveInsertionOrder().onFileNotFound((newfile, configFormat) -> ConfigBuilder.setupConfigFile(configFile, newfile, configFormat)).writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    private static boolean setupConfigFile(File path, Path file, ConfigFormat<?> conf) throws IOException {
        Path p = Paths.get(path.getPath(), new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public static void reload() {
        UnionConfig con;
        for (Class<?> configClass : ConfigClassBuilder.configs) {
            con = configClass.getAnnotation(UnionConfig.class);
            if (!con.autoReload()) continue;
            ConfigClassBuilder.read(configClass, new ModConfig.Type[0]);
            System.out.println("Detected change in " + con.name() + "'s config file. Reloading values");
        }
        for (ConfigObject configObject : ConfigObjectBuilder.configs) {
            con = configObject.getClass().getAnnotation(UnionConfig.class);
            if (!con.autoReload()) continue;
            ConfigObjectBuilder.read(configObject, new ModConfig.Type[0]);
            System.out.println("Detected change in " + con.name() + "'s config file. Reloading values");
        }
    }

    public static void load(ModConfig.Type ... exceptions) {
        UnionConfig con;
        System.out.println("Loading all values from the config files into their respective configuration variables");
        for (Class<?> configClass : ConfigClassBuilder.configs) {
            con = configClass.getAnnotation(UnionConfig.class);
            ConfigClassBuilder.read(configClass, exceptions);
            System.out.println("Loading " + con.name() + "'s config");
        }
        for (ConfigObject configObject : ConfigObjectBuilder.configs) {
            con = configObject.getClass().getAnnotation(UnionConfig.class);
            ConfigObjectBuilder.read(configObject, exceptions);
            System.out.println("Loading " + con.name() + "'s config");
        }
    }

    static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    public static class Holder {
        protected final ForgeConfigSpec.ConfigValue<?> value;
        protected final List<Component> comments;
        protected final boolean usesSider;
        protected final double min;
        protected final double max;

        public Holder(ForgeConfigSpec.ConfigValue<?> configvalue, List<Component> comments, boolean usesSider, double min, double max) {
            this.comments = comments;
            this.value = configvalue;
            this.usesSider = usesSider;
            this.min = min;
            this.max = max;
        }

        public ForgeConfigSpec.ConfigValue<?> getValue() {
            return this.value;
        }

        public List<Component> getComments() {
            return this.comments;
        }

        public boolean isUsesSider() {
            return this.usesSider;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventBus {
        @SubscribeEvent
        public static void onLoad(WorldEvent.Load event) {
            ConfigBuilder.load(ModConfig.Type.COMMON);
            if (!event.getWorld().m_5776_()) {
                System.out.println("Loading All Server Config Files");
                ConfigBuilder.load(ModConfig.Type.SERVER);
            } else {
                System.out.println("Loading All Client Config Files");
                ConfigBuilder.load(ModConfig.Type.CLIENT);
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBus {
        @SubscribeEvent
        public static void onLoad(ModConfigEvent.Loading event) {
            ConfigBuilder.load(new ModConfig.Type[0]);
        }

        @SubscribeEvent
        public static void onReload(ModConfigEvent.Reloading event) {
            ConfigBuilder.reload();
        }
    }
}

