/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.electronwill.nightconfig.core.EnumGetMethod;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stereowalker.unionlib.config.CommentedEnum;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.config.UnionConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigObjectBuilder {
    static final List<ConfigObject> configs = Lists.newArrayList();
    public static final Map<ConfigObject, Boolean> config_initialization = Maps.newHashMap();
    static final Map<ConfigObject, ForgeConfigSpec.Builder> client_builder = Maps.newHashMap();
    public static final Map<ConfigObject, ForgeConfigSpec> client_config = Maps.newHashMap();
    static final Map<ConfigObject, ForgeConfigSpec.Builder> common_builder = Maps.newHashMap();
    public static final Map<ConfigObject, ForgeConfigSpec> common_config = Maps.newHashMap();
    static final Map<ConfigObject, ForgeConfigSpec.Builder> server_builder = Maps.newHashMap();
    public static final Map<ConfigObject, ForgeConfigSpec> server_config = Maps.newHashMap();

    public static TranslatableComponent getConfigName(ConfigObject configObject) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configObject.getClass().getAnnotation(UnionConfig.class);
            if (config.translatableName().isEmpty()) {
                return new TranslatableComponent(config.name());
            }
            return new TranslatableComponent(config.translatableName());
        }
        return new TranslatableComponent("");
    }

    public static void read(ConfigObject configObject, ModConfig.Type ... readOnly) {
        ArrayList types = Lists.newArrayList((Object[])readOnly);
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configObject.getClass().getAnnotation(UnionConfig.class);
            for (Field field : configObject.getClass().getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || readOnly.length != 0 && !types.contains(configEntry.type())) continue;
                try {
                    if (ConfigBuilder.getConfigValue(config, configEntry).get() instanceof Double && field.get(configObject) instanceof Float) {
                        field.set(configObject, Float.valueOf(((Double)ConfigBuilder.getConfigValue(config, configEntry).get()).floatValue()));
                        continue;
                    }
                    field.set(configObject, ConfigBuilder.getConfigValue(config, configEntry).get());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void write(ConfigObject configObject) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configObject.getClass().getAnnotation(UnionConfig.class);
            for (Field field : configObject.getClass().getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || ConfigBuilder.getConfigValue(config, configEntry) == null) continue;
                try {
                    ConfigBuilder.getConfigValue(config, configEntry).set(field.get(configObject));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean hasConfigType(ConfigObject configObject, ModConfig.Type type) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
            for (Field field : configObject.getClass().getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || configEntry.type() != type) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void init(ConfigObject configObject, ForgeConfigSpec.Builder server, ForgeConfigSpec.Builder common, ForgeConfigSpec.Builder client) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configObject.getClass().getAnnotation(UnionConfig.class);
            for (Field field : configObject.getClass().getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null) continue;
                ModConfig.Type type = configEntry.type() != null ? configEntry.type() : ModConfig.Type.COMMON;
                ForgeConfigSpec.Builder builder = common;
                builder = type == ModConfig.Type.CLIENT ? client : (type == ModConfig.Type.SERVER ? server : common);
                try {
                    ForgeConfigSpec.ConfigValue conf;
                    Object enumComment = "";
                    if (field.get(configObject) instanceof CommentedEnum && field.get(configObject) instanceof Enum) {
                        enumComment = ((CommentedEnum)field.get(configObject)).getConfigComment();
                    }
                    enumComment = (String)enumComment + "\n";
                    String j = "\n###########################################";
                    String k = "\n-------------------------------------------";
                    String h = j + "\n";
                    Object comment = "";
                    ArrayList<Component> saved_comment = new ArrayList<Component>();
                    if (field.isAnnotationPresent(UnionConfig.Comment.class)) {
                        void var19_22;
                        String string = field.getAnnotation(UnionConfig.Comment.class).comment()[0];
                        if (field.getAnnotation(UnionConfig.Comment.class).comment().length > 1) {
                            for (int i = 1; i < field.getAnnotation(UnionConfig.Comment.class).comment().length; ++i) {
                                String string2 = (String)var19_22 + "\n" + field.getAnnotation(UnionConfig.Comment.class).comment()[i];
                            }
                        }
                        comment = h + (String)var19_22 + k + (String)enumComment + "Default: " + field.get(configObject) + k;
                        for (String s : var19_22.split("\n")) {
                            saved_comment.add((Component)new TextComponent(s).m_130940_(ChatFormatting.AQUA));
                        }
                        String[] i = ((String)enumComment).split("\n");
                        int n = i.length;
                        for (int i2 = 0; i2 < n; ++i2) {
                            String s;
                            s = i[i2];
                            saved_comment.add((Component)new TextComponent(s).m_130940_(ChatFormatting.YELLOW));
                        }
                        saved_comment.add((Component)new TextComponent("Default: " + field.get(configObject)).m_130940_(ChatFormatting.GREEN));
                    } else {
                        comment = h + (String)enumComment + "Default: " + field.get(configObject) + k;
                        for (String s : ((String)enumComment).split("\n")) {
                            saved_comment.add((Component)new TextComponent(s).m_130940_(ChatFormatting.YELLOW));
                        }
                        saved_comment.add((Component)new TextComponent("Default: " + field.get(configObject)).m_130940_(ChatFormatting.GREEN));
                    }
                    ForgeConfigSpec.Builder builder2 = builder.comment((String)comment);
                    Double min = 0.0;
                    Double max = 0.0;
                    if (field.get(configObject) instanceof Boolean) {
                        conf = builder2.define(ConfigBuilder.configName(configEntry, "Boolean"), (Object)((Boolean)field.get(configObject)));
                    } else if (field.get(configObject) instanceof Enum) {
                        Enum defaultValue = (Enum)field.get(configObject);
                        List<Enum> acceptableValues = Arrays.asList((Enum[])defaultValue.getDeclaringClass().getEnumConstants());
                        conf = builder2.defineEnum(ConfigBuilder.split(ConfigBuilder.configName(configEntry, "Enum")), Enum.valueOf(defaultValue.getDeclaringClass(), defaultValue.name()), EnumGetMethod.NAME_IGNORECASE, obj -> {
                            if (obj instanceof Enum) {
                                return acceptableValues.contains(obj);
                            }
                            if (obj == null) {
                                return false;
                            }
                            try {
                                return acceptableValues.contains(EnumGetMethod.NAME_IGNORECASE.get(obj, defaultValue.getDeclaringClass()));
                            }
                            catch (ClassCastException | IllegalArgumentException e) {
                                return false;
                            }
                        });
                    } else if (field.get(configObject) instanceof String) {
                        conf = builder2.define(ConfigBuilder.configName(configEntry, "String"), (Object)((String)field.get(configObject)));
                    } else if (field.isAnnotationPresent(UnionConfig.Range.class)) {
                        UnionConfig.Range range = field.getAnnotation(UnionConfig.Range.class);
                        min = range.min();
                        max = range.max();
                        conf = field.get(configObject) instanceof Integer ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Integer"), (Comparable)((Integer)field.get(configObject)), (Comparable)Integer.valueOf(min.intValue()), (Comparable)Integer.valueOf(max.intValue()), Integer.class) : (field.get(configObject) instanceof Float ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Float"), (Comparable)((Float)field.get(configObject)), (Comparable)Float.valueOf(min.floatValue()), (Comparable)Float.valueOf(max.floatValue()), Float.class) : (field.get(configObject) instanceof Long ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Long"), (Comparable)((Long)field.get(configObject)), (Comparable)Long.valueOf(min.longValue()), (Comparable)Long.valueOf(max.longValue()), Long.class) : (field.get(configObject) instanceof Short ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Short"), (Comparable)((Short)field.get(configObject)), (Comparable)Short.valueOf(min.shortValue()), (Comparable)Short.valueOf(max.shortValue()), Short.class) : (field.get(configObject) instanceof Byte ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Byte"), (Comparable)((Byte)field.get(configObject)), (Comparable)Byte.valueOf(min.byteValue()), (Comparable)Byte.valueOf(max.byteValue()), Byte.class) : builder2.defineInRange(ConfigBuilder.configName(configEntry, "Double"), (Comparable)((Double)field.get(configObject)), (Comparable)min, (Comparable)max, Double.class)))));
                    } else {
                        conf = builder2.define(ConfigBuilder.configName(configEntry), field.get(configObject));
                    }
                    ConfigBuilder.putValue(type, config.name() + "=" + ConfigBuilder.configName(configEntry), new ConfigBuilder.Holder(conf, saved_comment, field.isAnnotationPresent(UnionConfig.Slider.class), min, max));
                    config_initialization.put(configObject, true);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void registerConfigurations(ConfigObject configObject) {
        UnionConfig con = configObject.getClass().getAnnotation(UnionConfig.class);
        String name = con.folder().isEmpty() ? con.name() : con.folder() + "\\" + con.name();
        ConfigObjectBuilder.init(configObject, server_builder.get(configObject), common_builder.get(configObject), client_builder.get(configObject));
        server_config.put(configObject, server_builder.get(configObject).build());
        client_config.put(configObject, client_builder.get(configObject).build());
        common_config.put(configObject, common_builder.get(configObject).build());
        if (ConfigObjectBuilder.hasConfigType(configObject, ModConfig.Type.CLIENT)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)client_config.get(configObject), name + (con.appendWithType() ? "-client" : "") + ".toml");
        }
        if (ConfigObjectBuilder.hasConfigType(configObject, ModConfig.Type.COMMON)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)common_config.get(configObject), name + (con.appendWithType() ? "-common" : "") + ".toml");
        }
        if (ConfigObjectBuilder.hasConfigType(configObject, ModConfig.Type.SERVER)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)server_config.get(configObject), name + (con.appendWithType() ? "-server" : "") + ".toml");
        }
    }

    public static void loadConfigs(ConfigObject configObject) {
        UnionConfig con = configObject.getClass().getAnnotation(UnionConfig.class);
        if (ConfigObjectBuilder.hasConfigType(configObject, ModConfig.Type.CLIENT)) {
            ConfigBuilder.loadConfig(client_config.get(configObject), FMLPaths.CONFIGDIR.get().toString() + (String)(con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? "-client" : "") + ".toml");
        }
        if (ConfigObjectBuilder.hasConfigType(configObject, ModConfig.Type.COMMON)) {
            ConfigBuilder.loadConfig(common_config.get(configObject), FMLPaths.CONFIGDIR.get().toString() + (String)(con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? "-common" : "") + ".toml");
        }
        if (ConfigObjectBuilder.hasConfigType(configObject, ModConfig.Type.SERVER)) {
            ConfigBuilder.loadConfig(server_config.get(configObject), FMLPaths.CONFIGDIR.get().toString() + (String)(con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? "-server" : "") + ".toml");
        }
    }
}

