/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.event;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.inventory.UnionInventory;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BaseGameEvents {
    @SubscribeEvent
    public static void loadInventory(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntityLiving();
            UnionInventory unionInventory = UnionLib.getAccessoryInventory((Player)player);
            unionInventory.tick();
            if (!player.getPersistentData().m_128441_("UnionInventory")) {
                UnionLib.saveInventory((Player)player, unionInventory);
            }
        }
    }

    @SubscribeEvent
    public static void dropInventoryItems(LootingLevelEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            BaseGameEvents.dropInventory((Player)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        UnionInventory newUnionInventory = UnionLib.getAccessoryInventory(event.getPlayer());
        UnionInventory originalUnionInventory = UnionLib.getAccessoryInventory(event.getOriginal());
        if (!event.isWasDeath()) {
            newUnionInventory.copyInventory(originalUnionInventory);
        } else if (event.getPlayer().f_19853_.m_46469_().m_46207_(GameRules.f_46133_) || event.getOriginal().m_5833_()) {
            newUnionInventory.copyInventory(originalUnionInventory);
        }
        UnionLib.saveInventory(event.getPlayer(), newUnionInventory);
        UnionLib.saveInventory(event.getOriginal(), originalUnionInventory);
    }

    protected static void dropInventory(Player player) {
        UnionInventory unionInventory = UnionLib.getAccessoryInventory(player);
        if (!player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            BaseGameEvents.destroyVanishingCursedItems(player);
            unionInventory.dropAllItems();
        }
    }

    protected static void destroyVanishingCursedItems(Player player) {
        UnionInventory unionInventory = UnionLib.getAccessoryInventory(player);
        for (int i = 0; i < unionInventory.m_6643_(); ++i) {
            ItemStack itemstack = unionInventory.m_8020_(i);
            if (itemstack.m_41619_() || !EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            unionInventory.m_8016_(i);
        }
    }
}

