/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.inventory.container;

import com.mojang.datafixers.util.Pair;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.inventory.UnionInventory;
import com.stereowalker.unionlib.inventory.container.UContainerType;
import com.stereowalker.unionlib.item.AccessoryItem;
import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UnionContainer
extends RecipeBookMenu<CraftingContainer> {
    public static final ResourceLocation LOCATION_BLOCKS_TEXTURE = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = new ResourceLocation("item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = new ResourceLocation("item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = new ResourceLocation("item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = new ResourceLocation("item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = new ResourceLocation("item/empty_armor_slot_shield");
    public static final ResourceLocation EMPTY_ACCESSORY_SLOT_NECKLACE = UnionLib.location("item/empty_accessory_slot_necklace");
    public static final ResourceLocation EMPTY_ACCESSORY_SLOT_RING = UnionLib.location("item/empty_accessory_slot_ring");
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final ResourceLocation[] ACCESSORY_SLOT_TEXTURES = new ResourceLocation[]{EMPTY_ACCESSORY_SLOT_NECKLACE, EMPTY_ACCESSORY_SLOT_RING};
    private static final AccessoryItem.AccessorySlotType[] VALID_ACCESSORY_SLOTS = new AccessoryItem.AccessorySlotType[]{AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.RING, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.RING, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.NECKLACE};
    private final CraftingContainer craftMatrix = new CraftingContainer((AbstractContainerMenu)this, 2, 2);
    private final ResultContainer craftResult = new ResultContainer();
    private final UnionInventory inventory;
    public final boolean isLocalWorld;
    private final Player player;

    public UnionContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, new UnionInventory(playerInventory.f_35978_), false, playerInventory.f_35978_);
    }

    public UnionContainer(int id, Inventory playerInventory, UnionInventory unionInventory, boolean localWorld, Player playerIn) {
        super(UContainerType.UNION, id);
        int l;
        this.isLocalWorld = localWorld;
        this.player = playerIn;
        this.inventory = unionInventory;
        this.m_38897_((Slot)new ResultSlot(playerInventory.f_35978_, this.craftMatrix, (Container)this.craftResult, 0, 143, 62));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.m_38897_(new Slot((Container)this.craftMatrix, j + i * 2, 134 + j * 18, 8 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.m_38897_(new Slot((Container)playerInventory, 39 - k, 8, 8 + k * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)UnionContainer.this.player);
                }

                public boolean m_8010_(Player playerIn) {
                    ItemStack itemstack = this.m_7993_();
                    return !itemstack.m_41619_() && !playerIn.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)itemstack) ? false : super.m_8010_(playerIn);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)LOCATION_BLOCKS_TEXTURE, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.m_20749_()]);
                }
            });
        }
        for (l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.m_38897_(new Slot((Container)playerInventory, 40, 77, 62){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> getBackground() {
                return Pair.of((Object)LOCATION_BLOCKS_TEXTURE, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        for (l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 3; ++j1) {
                int index = j1 + l * 3;
                final AccessoryItem.AccessorySlotType accessoryslottype = VALID_ACCESSORY_SLOTS[index];
                this.m_38897_(new Slot((Container)unionInventory, index, 77 + j1 * 18, 8 + l * 18){

                    public int m_6641_() {
                        return 1;
                    }

                    public boolean m_5857_(ItemStack stack) {
                        return accessoryslottype.getValidStack().test(stack);
                    }

                    public boolean m_8010_(Player playerIn) {
                        ItemStack itemstack = this.m_7993_();
                        return !itemstack.m_41619_() && !playerIn.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)itemstack) ? false : super.m_8010_(playerIn);
                    }

                    @OnlyIn(value=Dist.CLIENT)
                    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                        return Pair.of((Object)LOCATION_BLOCKS_TEXTURE, (Object)ACCESSORY_SLOT_TEXTURES[accessoryslottype.getIndex()]);
                    }
                });
            }
        }
    }

    public void m_5816_(StackedContents itemHelperIn) {
        this.craftMatrix.m_5809_(itemHelperIn);
    }

    public void m_6650_() {
        this.craftResult.m_6211_();
        this.craftMatrix.m_6211_();
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipeIn) {
        return recipeIn.m_5818_((Container)this.craftMatrix, this.player.f_19853_);
    }

    public void m_6199_(Container inventoryIn) {
        UnionLib.saveInventory(this.player, this.inventory);
        UnionContainer.updateCraftingResult(this, this.player.f_19853_, this.player, this.craftMatrix, this.craftResult);
    }

    protected static void updateCraftingResult(UnionContainer container, Level world, Player player, CraftingContainer inventory, ResultContainer inventoryResult) {
        if (!world.f_46443_) {
            CraftingRecipe icraftingrecipe;
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = world.m_142572_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)inventory, world);
            if (optional.isPresent() && inventoryResult.m_40135_(world, serverplayerentity, (Recipe)(icraftingrecipe = (CraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.m_5874_((Container)inventory);
            }
            inventoryResult.m_6836_(0, itemstack);
            serverplayerentity.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(container.f_38840_, container.m_182425_(), 0, itemstack));
        }
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.craftResult.m_6211_();
        if (!playerIn.f_19853_.f_46443_) {
            this.m_150411_(playerIn, (Container)this.craftMatrix);
        }
        UnionLib.saveInventory(playerIn, this.inventory);
    }

    public boolean m_6875_(Player playerIn) {
        UnionLib.saveInventory(this.player, this.inventory);
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int i;
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            EquipmentSlot equipmentslottype = Mob.m_147233_((ItemStack)itemstack);
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 9, 45, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 1 && index < 5 ? !this.m_38903_(itemstack1, 9, 45, false) : (index >= 5 && index < 9 ? !this.m_38903_(itemstack1, 9, 45, false) : (equipmentslottype.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(8 - equipmentslottype.m_20749_())).m_6657_() ? !this.m_38903_(itemstack1, i = 8 - equipmentslottype.m_20749_(), i + 1, false) : (equipmentslottype == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(45)).m_6657_() ? !this.m_38903_(itemstack1, 45, 46, false) : (index >= 9 && index < 36 ? !this.m_38903_(itemstack1, 36, 45, false) : (index >= 36 && index < 45 ? !this.m_38903_(itemstack1, 9, 36, false) : !this.m_38903_(itemstack1, 9, 45, false))))))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
            if (index == 0) {
                playerIn.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.craftResult && super.m_5882_(stack, slotIn);
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return this.craftMatrix.m_39347_();
    }

    public int m_6656_() {
        return this.craftMatrix.m_39346_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_6653_() {
        return 5;
    }

    public CraftingContainer getCraftSlots() {
        return this.craftMatrix;
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int p_150591_) {
        return p_150591_ != this.m_6636_();
    }
}

