/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mod;

import com.google.common.collect.Lists;
import com.stereowalker.unionlib.UnionLib;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import net.minecraftforge.fmllegacy.MavenVersionStringHelper;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class MinecraftMod {
    private String modid;
    private LoadType loadType;
    private ResourceLocation modTexture;
    private IModInfo modInfo;
    private final String NETWORK_PROTOCOL_VERSION = "1";
    public final SimpleChannel channel;
    protected int netID = -1;

    public MinecraftMod(String modid, ResourceLocation modTexture, LoadType loadType, boolean shouldLoadMod) {
        this.modid = modid;
        this.modTexture = modTexture;
        this.loadType = loadType;
        if (shouldLoadMod) {
            UnionLib.mods.add(this);
            ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((minecraft, parentScreen) -> this.getConfigScreen((Minecraft)minecraft, (Screen)parentScreen)));
            if (this.loadType != LoadType.CLIENT) {
                this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)this.location("main_simple_channel"), () -> "1", "1"::equals, "1"::equals);
                this.registerMessages(this.channel);
            } else {
                this.channel = null;
            }
        } else {
            this.channel = null;
        }
    }

    public MinecraftMod(String modid, ResourceLocation modTexture, LoadType loadType) {
        this(modid, modTexture, loadType, true);
    }

    public LoadType getLoadType() {
        return this.loadType;
    }

    public String getModid() {
        return this.modid;
    }

    public Logger getLogger() {
        return LogManager.getLogger((String)this.modid);
    }

    public ResourceLocation getModTexture() {
        return this.modTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping[] getModKeyMappings() {
        return new KeyMapping[0];
    }

    public ResourceLocation location(String name) {
        return new ResourceLocation(this.modid, name);
    }

    public String locationString(String name) {
        return this.modid + ":" + name;
    }

    public void registerMessages(SimpleChannel channel) {
    }

    public List<Class<?>> getRegistries() {
        return Lists.newArrayList();
    }

    public IModInfo getModInfo() {
        ModList.get().getMods().forEach(mod -> {
            if (mod.getModId() == this.getModid()) {
                this.modInfo = mod;
            }
        });
        return this.modInfo;
    }

    public String getVersion() {
        if (this.getModInfo() != null) {
            return MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)this.getModInfo().getVersion());
        }
        return "???";
    }

    public static enum LoadType {
        CLIENT,
        BOTH,
        SERVER;

    }
}

