/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.network.server;

import com.stereowalker.unionlib.network.BasePacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;

public abstract class SUnionPacket
extends BasePacket {
    public SUnionPacket(SimpleChannel channel) {
        super(channel);
    }

    public SUnionPacket(FriendlyByteBuf packetBuffer, SimpleChannel channel) {
        super(packetBuffer, channel);
    }

    @Override
    public void message(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (this.shouldRun()) {
            context.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> context.setPacketHandled(this.handleOnClient(Minecraft.m_91087_().f_91074_))));
        }
    }

    public boolean shouldRun() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract boolean handleOnClient(LocalPlayer var1);

    public void send(ServerPlayer playerEntity) {
        this.channel.sendTo((Object)this, playerEntity.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void send(ServerLevel world) {
        for (ServerPlayer playerEntity : world.m_6907_()) {
            this.send(playerEntity);
        }
    }

    public void send(MinecraftServer server) {
        for (ServerPlayer playerEntity : server.m_6846_().m_11314_()) {
            this.send(playerEntity);
        }
    }
}

