/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.registries;

import com.google.common.collect.Lists;
import com.stereowalker.unionlib.registries.RegistryHolder;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegisterObjects {
    static final List<Class<?>> registries = Lists.newArrayList();

    public static void register(Class<?> re) {
        registries.add(re);
    }

    public static void putItemsInForgeRegistries(IForgeRegistry<Item> forgeRegistry) {
        for (Class<?> classs : registries) {
            System.out.println("UnionLib Registry: Found class");
            RegistryHolder reg = null;
            boolean hasAnnotation = classs.isAnnotationPresent(RegistryHolder.class);
            if (hasAnnotation) {
                reg = classs.getAnnotation(RegistryHolder.class);
            }
            for (Field field : classs.getFields()) {
                if (!field.isAnnotationPresent(RegistryHolder.class)) continue;
                RegistryHolder regi = field.getAnnotation(RegistryHolder.class);
                try {
                    if (field.get(null) == null || !(field.get(null) instanceof Item)) continue;
                    Item item = (Item)field.get(null);
                    if (hasAnnotation) {
                        item.setRegistryName(new ResourceLocation(reg.value() + ":" + regi.value()));
                    } else {
                        item.setRegistryName(new ResourceLocation(regi.value()));
                    }
                    forgeRegistry.register((IForgeRegistryEntry)item);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

