/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.api;

import com.google.common.collect.Multimap;
import com.google.gson.annotations.SerializedName;
import com.stereowalker.tiered.Tiered;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeTemplate {
    @SerializedName(value="type")
    private final String attributeTypeID;
    @SerializedName(value="modifier")
    private final AttributeModifier attributeModifier;
    @SerializedName(value="required_equipment_slots")
    private final EquipmentSlot[] requiredEquipmentSlotTypes;
    @SerializedName(value="optional_equipment_slots")
    private final EquipmentSlot[] optionalEquipmentSlotTypes;
    @SerializedName(value="required_accessory_slots")
    private final AccessorySlot[] requiredAccessorySlotTypes;
    @SerializedName(value="optional_accessory_slots")
    private final AccessorySlot[] optionalAccessorySlotTypes;
    @SerializedName(value="required_accessory_groups")
    private final AccessorySlot.Group[] requiredAccessoryGroupTypes;
    @SerializedName(value="optional_accessory_groups")
    private final AccessorySlot.Group[] optionalAccessoryGroupTypes;
    @SerializedName(value="required_curio_slots")
    private final String[] requiredCurioSlotTypes;
    @SerializedName(value="optional_curio_slots")
    private final String[] optionalCurioSlotTypes;

    public AttributeTemplate(String attributeTypeID, AttributeModifier AttributeModifier2, EquipmentSlot[] requiredEquipmentSlotTypes, EquipmentSlot[] optionalEquipmentSlotTypes, AccessorySlot[] requiredAccessorySlotTypes, AccessorySlot[] optionalAccessorySlotTypes, AccessorySlot.Group[] requiredAccessoryGroupTypes, AccessorySlot.Group[] optionalAccessoryGroupTypes, String[] requiredCurioSlotTypes, String[] optionalCurioSlotTypes) {
        this.attributeTypeID = attributeTypeID;
        this.attributeModifier = AttributeModifier2;
        this.requiredEquipmentSlotTypes = requiredEquipmentSlotTypes;
        this.optionalEquipmentSlotTypes = optionalEquipmentSlotTypes;
        this.requiredAccessorySlotTypes = requiredAccessorySlotTypes;
        this.optionalAccessorySlotTypes = optionalAccessorySlotTypes;
        this.requiredAccessoryGroupTypes = requiredAccessoryGroupTypes;
        this.optionalAccessoryGroupTypes = optionalAccessoryGroupTypes;
        this.requiredCurioSlotTypes = requiredCurioSlotTypes;
        this.optionalCurioSlotTypes = optionalCurioSlotTypes;
    }

    public EquipmentSlot[] getRequiredEquipmentSlot() {
        return this.requiredEquipmentSlotTypes;
    }

    public EquipmentSlot[] getOptionalEquipmentSlot() {
        return this.optionalEquipmentSlotTypes;
    }

    public AccessorySlot[] getRequiredAccessorySlot() {
        return this.requiredAccessorySlotTypes;
    }

    public AccessorySlot[] getOptionalAccessorySlot() {
        return this.optionalAccessorySlotTypes;
    }

    public AccessorySlot.Group[] getRequiredAccessoryGroup() {
        return this.requiredAccessoryGroupTypes;
    }

    public AccessorySlot.Group[] getOptionalAccessoryGroup() {
        return this.optionalAccessoryGroupTypes;
    }

    public String[] getRequiredCurioSlot() {
        return this.requiredCurioSlotTypes;
    }

    public String[] getOptionalCurioSlot() {
        return this.optionalCurioSlotTypes;
    }

    public void realize(Multimap<Attribute, AttributeModifier> multimap, EquipmentSlot slot) {
        this.realize((arg_0, arg_1) -> multimap.put(arg_0, arg_1), Tiered.MODIFIERS[slot.m_20750_()], slot.m_20751_());
    }

    public void realize(Multimap<Attribute, AttributeModifier> multimap, AccessorySlot slot) {
        this.realize((arg_0, arg_1) -> multimap.put(arg_0, arg_1), Tiered.MODIFIERS[slot.getIndex() + 6], slot.getName());
    }

    public void realize(Multimap<Attribute, AttributeModifier> multimap, AccessorySlot.Group slot) {
        this.realize((arg_0, arg_1) -> multimap.put(arg_0, arg_1), Tiered.MODIFIERS[slot.ordinal() + 15], slot.getName());
    }

    public void realize(BiConsumer<Attribute, AttributeModifier> multimap, String slot) {
        this.realize(multimap, Tiered.CURIO_MODIFIERS.getOrDefault(slot, UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7c")), slot);
    }

    private void realize(BiConsumer<Attribute, AttributeModifier> multimap, UUID id, String name) {
        AttributeModifier cloneModifier = new AttributeModifier(id, this.attributeModifier.m_22214_() + "_" + name, this.attributeModifier.m_22218_(), this.attributeModifier.m_22217_());
        Attribute key = (Attribute)RegistryHelper.attributes().m_7745_(new ResourceLocation(this.attributeTypeID));
        if (key == null) {
            Tiered.LOGGER.warn(String.format("%s was referenced as an attribute type, but it does not exist! A data file in /tiered/item_attributes/ has an invalid type property.", this.attributeTypeID));
        } else {
            multimap.accept(key, cloneModifier);
        }
    }
}

