/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.stereowalker.unionlib.client.gui.components.OverlayImageButton;
import com.stereowalker.unionlib.client.gui.screens.ModConfigurationScreen;
import com.stereowalker.unionlib.client.gui.screens.UnionModsScreen;
import com.stereowalker.unionlib.client.gui.screens.controls.ModControlsScreen;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.util.ScreenHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModList
extends ContainerObjectSelectionList<Entry> {
    public ModList(Minecraft mcIn, UnionModsScreen screen) {
        super(mcIn, screen.f_96543_ + 45, screen.f_96544_, 43, screen.f_96544_ - 32, 25);
        for (MinecraftMod mod : ModHandler.mods.values()) {
            this.m_7085_((AbstractSelectionList.Entry)new ModEntry(mod, screen));
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 40;
    }

    public int m_5759_() {
        return super.m_5759_() + 72;
    }

    public class ModEntry
    extends Entry {
        private final MinecraftMod mod;
        private final Screen screen;
        private final Button modImage;
        private final Button configButton;
        private final boolean noConfig;

        private ModEntry(MinecraftMod mod, Screen screen) {
            this.mod = mod;
            this.screen = screen;
            ArrayList keys = Lists.newArrayList();
            this.mod.setupKeymappings(keys::add);
            this.modImage = new OverlayImageButton(0, 0, 20, 20, 0, 0, 20, 20, mod.getModTexture(), 20, 20, onPress -> {}, (Component)Component.m_237115_((String)"menu.button.union"));
            if (this.mod.getConfigScreen(ModList.this.f_93386_, this.screen) != null && keys.size() <= 0) {
                this.configButton = ScreenHelper.buttonBuilder((Component)Component.m_237115_((String)"union.gui.config"), onPress -> ModList.this.f_93386_.m_91152_(mod.getConfigScreen(ModList.this.f_93386_, this.screen))).bounds(0, 0, 200, 20).build();
                this.noConfig = false;
            } else if (keys.size() > 0 && this.mod.getConfigScreen(ModList.this.f_93386_, this.screen) == null) {
                this.configButton = ScreenHelper.buttonBuilder((Component)Component.m_237115_((String)"union.gui.controls"), onPress -> ModList.this.f_93386_.m_91152_((Screen)new ModControlsScreen(mod, this.screen, screen.getMinecraft().f_91066_))).bounds(0, 0, 200, 20).build();
                this.noConfig = false;
            } else if (keys.size() > 0 && this.mod.getConfigScreen(ModList.this.f_93386_, this.screen) != null) {
                this.configButton = ScreenHelper.buttonBuilder((Component)Component.m_237115_((String)"union.gui.setup"), onPress -> ModList.this.f_93386_.m_91152_((Screen)new ModConfigurationScreen(mod, screen))).bounds(0, 0, 200, 20).build();
                this.noConfig = false;
            } else {
                this.configButton = ScreenHelper.buttonBuilder((Component)Component.m_237115_((String)"union.gui.controls"), onPress -> {}).bounds(0, 0, 200, 20).build();
                this.noConfig = true;
            }
        }

        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ScreenHelper.setWidgetPosition((AbstractWidget)this.modImage, p_230432_4_, p_230432_3_);
            this.modImage.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            ScreenHelper.setWidgetPosition((AbstractWidget)this.configButton, p_230432_4_ + 50, p_230432_3_);
            this.configButton.f_93623_ = !this.noConfig;
            this.configButton.m_6305_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.modImage, (Object)this.configButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.modImage, (Object)this.configButton);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.modImage.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return this.configButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.modImage.m_6348_(mouseX, mouseY, button) || this.configButton.m_6348_(mouseX, mouseY, button);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

