/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.stereowalker.unionlib.client.gui.components.OverflowTextButton;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.config.lists.ListScreen;
import com.stereowalker.unionlib.client.gui.widget.button.Slider;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ConfigHolder;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.ScreenHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigList
extends ContainerObjectSelectionList<Entry> {
    protected ConfigScreen screen;
    protected List<Component> tooltip = null;
    protected int tooltipX = 0;
    protected int tooltipY = 0;
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    public ConfigList(Minecraft mcIn, ConfigScreen screen, UnionConfig config) {
        super(mcIn, screen.f_96543_ + 45, screen.f_96544_, 43, screen.f_96544_ - 32, 25);
        this.screen = screen;
        List<String> c = Arrays.asList(ConfigBuilder.getValues(config).keySet().toArray(new String[0]));
        Collections.sort(c);
        String currentCategory = "";
        for (String configValue : c) {
            Object name = "";
            for (int i = 1; i < configValue.split("=").length; ++i) {
                name = (String)name + configValue.split("=")[i];
            }
            if (ConfigList.split((String)name).size() > 1 && !ConfigList.split((String)name).get(0).equals(currentCategory)) {
                this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)ConfigList.split((String)name).get(0))));
                currentCategory = ConfigList.split((String)name).get(0);
            }
            Object name2 = "";
            if (ConfigList.split((String)name).size() > 1) {
                for (int i = 1; i < ConfigList.split((String)name).size(); ++i) {
                    name2 = (String)name2 + ConfigList.split((String)name).get(i);
                }
            } else {
                name2 = name;
            }
            ConfigHolder<Boolean> holder = ConfigBuilder.getValues(config).get(configValue);
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Boolean) {
                this.m_7085_((AbstractSelectionList.Entry)new BooleanEntry((Component)Component.m_237115_((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof String) {
                this.m_7085_((AbstractSelectionList.Entry)new StringEntry((Component)Component.m_237115_((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Enum) {
                this.m_7085_((AbstractSelectionList.Entry)new EnumEntry((Component)Component.m_237115_((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Number) {
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Double) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237115_((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Float) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237115_((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Long) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237115_((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Short) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237115_((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Byte) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237115_((String)name2), holder));
                    continue;
                }
                this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237115_((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof List) {
                this.m_7085_((AbstractSelectionList.Entry)new ListEntry((Component)Component.m_237115_((String)name2), holder));
                continue;
            }
            this.m_7085_((AbstractSelectionList.Entry)new ConfigEntry<Boolean>((Component)Component.m_237115_((String)name2), holder));
        }
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 40;
    }

    public int m_5759_() {
        return super.m_5759_() + 72;
    }

    public void tick() {
        for (Entry ent : this.m_6702_()) {
            if (!(ent instanceof ConfigEntry)) continue;
            ((ConfigEntry)ent).tick();
        }
    }

    public class CategoryEntry
    extends Entry {
        private final Component labelText;
        private final int labelWidth;

        public CategoryEntry(Component p_i232280_2_) {
            this.labelText = p_i232280_2_;
            this.labelWidth = ((ConfigList)ConfigList.this).f_93386_.f_91062_.m_92852_((FormattedText)this.labelText);
        }

        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ((ConfigList)ConfigList.this).f_93386_.f_91062_.m_92889_(p_230432_1_, this.labelText, (float)(((ConfigList)ConfigList.this).f_93386_.f_91080_.f_96543_ / 2 - this.labelWidth / 2), (float)(p_230432_3_ + p_230432_6_ - 9 - 1), 0xFFFFFF);
        }

        public boolean m_5755_(boolean focus) {
            return false;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }
    }

    public class BooleanEntry
    extends ConfigEntry<Boolean> {
        private BooleanEntry(Component name, ConfigHolder<Boolean> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            this.configInteractable = ScreenHelper.buttonBuilder(name, onPress -> {
                this.config.getValue().set((Object)((Boolean)this.config.getValue().get() == false ? 1 : 0));
                ConfigBuilder.reload(this.config.getParentFile(), new ModConfig.Type[0]);
            }).bounds(0, 0, this.interactionWidth, 20).build();
        }

        @Override
        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.m_6311_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.configInteractable.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)this.config.getValue().get())));
        }
    }

    public class StringEntry
    extends ConfigEntry<String> {
        private StringEntry(Component name, ConfigHolder<String> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            if (this.configInteractable instanceof EditBox) {
                ((EditBox)this.configInteractable).m_94144_((String)this.config.getValue().get());
            } else {
                this.configInteractable = new EditBox(((ConfigList)ConfigList.this).f_93386_.f_91062_, 0, 0, this.interactionWidth, 20, (Component)Component.m_237115_((String)"config.editBox"));
                ((EditBox)this.configInteractable).m_94144_((String)this.config.getValue().get());
                ((EditBox)this.configInteractable).m_94151_(p_214319_1_ -> {
                    this.config.getValue().set(p_214319_1_);
                    ConfigBuilder.reload(this.config.getParentFile(), new ModConfig.Type[0]);
                });
            }
        }

        @Override
        public void tick() {
            ((EditBox)this.configInteractable).m_94120_();
        }
    }

    public class EnumEntry
    extends ConfigEntry<Enum<?>> {
        private EnumEntry(Component name, ConfigHolder<Enum<?>> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            this.configInteractable = ScreenHelper.buttonBuilder(name, onPress -> {
                this.config.getValue().set((Object)RegistryHelper.rotateEnumForward((Enum)((Enum)this.config.getValue().get()), (Enum[])((Enum[])((Enum)this.config.getValue().get()).getDeclaringClass().getEnumConstants())));
                ConfigBuilder.reload(this.config.getParentFile(), new ModConfig.Type[0]);
            }).bounds(0, 0, this.interactionWidth, 20).build();
        }

        @Override
        public void m_6311_(PoseStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.m_6311_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.configInteractable.m_93666_((Component)Component.m_237115_((String)((Enum)this.config.getValue().get()).name()));
        }
    }

    public class NumberedEntry<V extends Number>
    extends ConfigEntry<V> {
        private NumberedEntry(Component name, ConfigHolder<V> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            double shiftedMax = this.config.getMax() - this.config.getMin();
            if (this.config.isUsingSlider()) {
                if (this.configInteractable instanceof Slider) {
                    ((Slider)this.configInteractable).m_93611_(((Number)this.config.getValue().get()).doubleValue() / shiftedMax);
                } else {
                    this.configInteractable = new Slider(0, 0, this.interactionWidth, 20, ((Number)this.config.getValue().get()).doubleValue() / shiftedMax, (Component)Component.m_237113_((String)((Number)this.config.getValue().get()).toString()));
                    ((Slider)this.configInteractable).setResponder(val -> {
                        if (this.config.isUsingSlider()) {
                            Number oldValue = (Number)this.config.getValue().get();
                            Double newValue = val * shiftedMax + this.config.getMin();
                            try {
                                if (this.config.getValue().get() instanceof Double) {
                                    this.config.getValue().set((Object)newValue);
                                } else if (this.config.getValue().get() instanceof Float) {
                                    this.config.getValue().set((Object)Float.valueOf(newValue.floatValue()));
                                } else if (this.config.getValue().get() instanceof Long) {
                                    this.config.getValue().set((Object)newValue.longValue());
                                } else if (this.config.getValue().get() instanceof Short) {
                                    this.config.getValue().set((Object)newValue.shortValue());
                                } else if (this.config.getValue().get() instanceof Byte) {
                                    this.config.getValue().set((Object)newValue.byteValue());
                                } else {
                                    this.config.getValue().set((Object)newValue.intValue());
                                }
                            }
                            catch (NumberFormatException e) {
                                this.config.getValue().set((Object)oldValue);
                            }
                            ConfigBuilder.reload(this.config.getParentFile(), new ModConfig.Type[0]);
                            ((Slider)this.configInteractable).m_93666_((Component)Component.m_237113_((String)((Number)this.config.getValue().get()).toString()));
                        }
                    });
                }
            } else if (this.configInteractable instanceof EditBox) {
                ((EditBox)this.configInteractable).m_94144_(((Number)this.config.getValue().get()).toString());
            } else {
                this.configInteractable = new EditBox(((ConfigList)ConfigList.this).f_93386_.f_91062_, 0, 0, this.interactionWidth, 20, (Component)Component.m_237115_((String)"config.editNumberBox"));
                ((EditBox)this.configInteractable).m_94144_(((Number)this.config.getValue().get()).toString());
                ((EditBox)this.configInteractable).m_94153_(text -> {
                    Number oldValue = (Number)this.config.getValue().get();
                    Number newValue = null;
                    try {
                        newValue = oldValue instanceof Double ? (Number)Double.parseDouble(text) : (Number)(oldValue instanceof Float ? (Number)Float.valueOf(Float.parseFloat(text)) : (Number)(oldValue instanceof Long ? (Number)Long.parseLong(text) : (Number)(oldValue instanceof Short ? (Number)Short.parseShort(text) : (Number)(oldValue instanceof Byte ? (Number)Byte.parseByte(text) : (Number)Integer.parseInt(text)))));
                        return newValue != null;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                });
                ((EditBox)this.configInteractable).m_94151_(text -> {
                    Number oldValue = (Number)this.config.getValue().get();
                    Number newValue = null;
                    try {
                        newValue = oldValue instanceof Double ? (Number)Double.parseDouble(text) : (Number)(oldValue instanceof Float ? (Number)Float.valueOf(Float.parseFloat(text)) : (Number)(oldValue instanceof Long ? (Number)Long.parseLong(text) : (Number)(oldValue instanceof Short ? (Number)Short.parseShort(text) : (Number)(oldValue instanceof Byte ? (Number)Byte.parseByte(text) : (Number)Integer.parseInt(text)))));
                        this.config.getValue().set((Object)newValue);
                        ConfigBuilder.reload(this.config.getParentFile(), new ModConfig.Type[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
            }
        }

        @Override
        public void tick() {
            if (this.configInteractable instanceof EditBox) {
                ((EditBox)this.configInteractable).m_94120_();
            }
        }
    }

    public class ListEntry
    extends ConfigEntry<List<?>> {
        private ListEntry(Component name, ConfigHolder<List<?>> config) {
            super(name, config);
            this.configInteractable = ScreenHelper.buttonBuilder((Component)Component.m_237115_((String)"list"), onPress -> ConfigList.this.f_93386_.m_91152_((Screen)new ListScreen(name, ConfigList.this.screen, config.getValue()))).bounds(0, 0, this.interactionWidth, 20).build();
        }
    }

    public class ConfigEntry<T>
    extends Entry {
        protected final ConfigHolder<T> config;
        protected final Button configButton;
        protected AbstractWidget configInteractable;
        protected final Button resetButton;
        protected final int interactionWidth;

        public void tick() {
        }

        public void reset(Component name) {
            this.configInteractable = null;
        }

        private ConfigEntry(Component name, ConfigHolder<T> config) {
            this.config = config;
            this.interactionWidth = 140;
            this.configButton = new OverflowTextButton(0, 0, 195, 20, name, onPress -> {}, (button, stack, x, y) -> {
                int space = ((ConfigList)ConfigList.this).f_93386_.f_91080_.f_96544_ - y;
                int textHeight = config.getComments().size();
                int drawY = y;
                if (textHeight * 15 > space) {
                    drawY -= textHeight * 15 - space;
                }
                if (config.getComments() != null) {
                    ConfigList.this.tooltip = config.getComments();
                    ConfigList.this.tooltipX = x;
                    ConfigList.this.tooltipY = drawY;
                }
            });
            MutableComponent c = Component.m_237119_();
            config.getComments().subList(0, config.getComments().size() - 1).forEach(el -> c.m_7220_(el).m_130946_("\n"));
            c.m_7220_(config.getComments().get(config.getComments().size() - 1));
            this.reset(name);
            this.resetButton = new OverflowTextButton(0, 0, 40, 20, (Component)Component.m_237115_((String)"controls.reset"), onPress -> {
                this.config.getValue().set(this.config.getDefaultValue());
                this.reset(name);
            });
            ConfigList.this.screen.addChild(this.configInteractable);
            ConfigList.this.screen.addChild(this.resetButton);
        }

        public void m_6311_(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            if (this.configInteractable != null) {
                ScreenHelper.setWidgetPosition(this.configInteractable, pLeft + 125, pTop);
                this.configInteractable.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
            ScreenHelper.setWidgetPosition((AbstractWidget)this.configButton, pLeft - 80, pTop);
            this.configButton.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            this.configButton.f_93623_ = false;
            ScreenHelper.setWidgetPosition((AbstractWidget)this.resetButton, pLeft + 275, pTop);
            this.resetButton.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            this.resetButton.f_93623_ = !this.config.getValue().get().equals(this.config.getDefaultValue());
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.configInteractable == null ? ImmutableList.of((Object)this.configButton, (Object)this.resetButton) : ImmutableList.of((Object)this.configButton, (Object)this.resetButton, (Object)this.configInteractable);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.configInteractable == null ? ImmutableList.of((Object)this.configButton, (Object)this.resetButton) : ImmutableList.of((Object)this.configButton, (Object)this.resetButton, (Object)this.configInteractable);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.resetButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.configInteractable != null && this.configInteractable.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return this.configButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.resetButton.m_6348_(mouseX, mouseY, button) || this.configInteractable != null && this.configInteractable.m_6348_(mouseX, mouseY, button) || this.configButton.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.configInteractable != null) {
                return this.configInteractable.m_7933_(keyCode, scanCode, modifiers);
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.configInteractable != null && this.configInteractable.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (this.resetButton.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            return this.configButton.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

