/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.UnionConfig;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigClassBuilder {
    static final Map<Class<?>, List<String>> configs = Maps.newHashMap();
    public static final Map<Class<?>, Boolean> config_initialization = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> client_config = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> common_config = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> server_config = Maps.newHashMap();

    public static MutableComponent getConfigName(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            if (config.translatableName().isEmpty()) {
                return Component.m_237115_((String)config.name());
            }
            return Component.m_237115_((String)config.translatableName());
        }
        return Component.m_237115_((String)"");
    }

    public static void write(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || ConfigBuilder.getConfigValue(config, configEntry) == null) continue;
                try {
                    ConfigBuilder.getConfigValue(config, configEntry).set(field.get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean hasConfigType(Class<?> configClass, ModConfig.Type type) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || configEntry.type() != type) continue;
                return true;
            }
        }
        return false;
    }

    private static String configFileNames(String name, UnionConfig con, String appendage) {
        return name + (String)(con.appendWithType() ? "-" + appendage : "") + ".toml";
    }

    public static void registerConfigurations(Class<?> configClass) {
        UnionConfig con = configClass.getAnnotation(UnionConfig.class);
        String name = con.folder().isEmpty() ? con.name() : con.folder() + File.separator + con.name();
        ForgeConfigSpec.Builder client_builder = new ForgeConfigSpec.Builder();
        String client_filename = ConfigClassBuilder.configFileNames(name, con, "client");
        ForgeConfigSpec.Builder common_builder = new ForgeConfigSpec.Builder();
        String common_filename = ConfigClassBuilder.configFileNames(name, con, "common");
        ForgeConfigSpec.Builder server_builder = new ForgeConfigSpec.Builder();
        String server_filename = ConfigClassBuilder.configFileNames(name, con, "server");
        ConfigBuilder.init(configClass, null, server_builder, server_filename, common_builder, common_filename, client_builder, client_filename, () -> config_initialization.put(configClass, true));
        client_config.put(configClass, client_builder.build());
        common_config.put(configClass, common_builder.build());
        server_config.put(configClass, server_builder.build());
        ArrayList aliases = Lists.newArrayList();
        if (ConfigClassBuilder.hasConfigType(configClass, ModConfig.Type.CLIENT)) {
            aliases.add(client_filename);
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)client_config.get(configClass), client_filename);
        }
        if (ConfigClassBuilder.hasConfigType(configClass, ModConfig.Type.COMMON)) {
            aliases.add(common_filename);
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)common_config.get(configClass), common_filename);
        }
        if (ConfigClassBuilder.hasConfigType(configClass, ModConfig.Type.SERVER)) {
            aliases.add(server_filename);
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)server_config.get(configClass), server_filename);
        }
        configs.put(configClass, aliases);
    }

    public static void loadConfigs(Class<?> configClass) {
        UnionConfig con = configClass.getAnnotation(UnionConfig.class);
        if (ConfigClassBuilder.hasConfigType(configClass, ModConfig.Type.CLIENT)) {
            ConfigBuilder.loadConfig(client_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-client" : "") + ".toml");
        }
        if (ConfigClassBuilder.hasConfigType(configClass, ModConfig.Type.COMMON)) {
            ConfigBuilder.loadConfig(common_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-common" : "") + ".toml");
        }
        if (ConfigClassBuilder.hasConfigType(configClass, ModConfig.Type.SERVER)) {
            ConfigBuilder.loadConfig(server_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-server" : "") + ".toml");
        }
    }
}

