/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.forge;

import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import java.lang.reflect.Field;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

public class PlatformHelper {
    public static void handleInserts() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(evt -> Inserts.PLAYER_ATTACK.insert(evt.getEntity(), evt.getTarget(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }));
        forgeBus.addListener(evt -> Inserts.LIVING_FALL.insert(evt.getEntity(), evt.getDistance(), evt.getDamageMultiplier(), arg_0 -> ((LivingFallEvent)evt).setDistance(arg_0), arg_0 -> ((LivingFallEvent)evt).setDamageMultiplier(arg_0)));
        forgeBus.addListener(evt -> Inserts.FOV.insert(evt.getPlayer(), evt.getFovModifier(), evt.getNewFovModifier(), arg_0 -> ((ComputeFovModifierEvent)evt).setNewFovModifier(arg_0)));
        forgeBus.addListener(event -> Inserts.LIVING_ATTACK.insert(event.getEntity(), event.getSource(), event.getAmount()));
        forgeBus.addListener(event -> Inserts.LIVING_DEATH.insert(event.getEntity(), event.getSource()));
        forgeBus.addListener(event -> Inserts.LIVING_HEAL.insert(event.getEntity(), event.getAmount(), arg_0 -> ((LivingHealEvent)event).setAmount(arg_0)));
        forgeBus.addListener(event -> Inserts.ENTITY_JOIN_LEVEL.insert(event.getEntity(), event.getLevel(), event.loadedFromDisk()));
        forgeBus.addListener(event -> Inserts.ITEM_TOOLTIP.insert(event.getItemStack(), event.getEntity(), event.getToolTip(), event.getFlags()));
        forgeBus.addListener(event -> Inserts.FINISH_SLEEP.insert(event.getLevel(), event.getNewTime(), arg_0 -> ((SleepFinishedTimeEvent)event).setTimeAddition(arg_0)));
        forgeBus.addListener(event -> Inserts.LEVEL_SAVE.insert(event.getLevel()));
        forgeBus.addListener(event -> Inserts.LIVING_JUMP.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.LIVING_TICK.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.ITEM_USE_FINISH.insert(event.getEntity(), event.getItem(), event.getDuration(), event.getResultStack(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0)));
        forgeBus.addListener(event -> Inserts.MENU_CLOSE.insert(event.getEntity(), event.getContainer()));
        forgeBus.addListener(event -> Inserts.MENU_OPEN.insert(event.getEntity(), event.getContainer()));
        forgeBus.addListener(evt -> Inserts.INTERACT_WITH_ENTITY.insert(evt.getEntity(), evt.getHand(), evt.getTarget(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }, evt.getCancellationResult(), arg_0 -> ((PlayerInteractEvent.EntityInteract)evt).setCancellationResult(arg_0)));
        forgeBus.addListener(evt -> Inserts.INTERACT_WITH_BLOCK.insert(evt.getEntity(), evt.getHand(), evt.getPos(), evt.getHitVec(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }, evt.getCancellationResult(), arg_0 -> ((PlayerInteractEvent.RightClickBlock)evt).setCancellationResult(arg_0)));
        forgeBus.addListener(event -> Inserts.PLAYER_RESTORE.insert(event.getEntity(), event.getOriginal(), !event.isWasDeath()));
        forgeBus.addListener(event -> Inserts.LOGGED_OUT.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.LOGGED_IN.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.XP_PICKUP.insert(event.getEntity(), event.getOrb()));
    }

    public static void handleRegistration(MinecraftMod mod, String namespace, Field[] fields, RegistryHolder reg, Logger LOGGER) {
        DeferredRegister BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)namespace);
        DeferredRegister FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)namespace);
        DeferredRegister ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)namespace);
        DeferredRegister ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)namespace);
        DeferredRegister MOB_EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)namespace);
        DeferredRegister SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)namespace);
        DeferredRegister ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)namespace);
        DeferredRegister MENU_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)namespace);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(RegistryObject.class)) continue;
            RegistryObject regi = field.getAnnotation(RegistryObject.class);
            String regName = regi.value();
            if (reg.registry() == Block.class) {
                BLOCKS.register(regName, () -> {
                    try {
                        return (Block)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        LOGGER.warn("There was an error registering " + regName);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == Fluid.class) {
                FLUIDS.register(regName, () -> {
                    try {
                        return (Fluid)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        LOGGER.warn("There was an error registering " + regName);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == Enchantment.class) {
                ENCHANTMENTS.register(regName, () -> {
                    try {
                        return (Enchantment)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        LOGGER.warn("There was an error registering " + regName);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == Item.class) {
                ITEMS.register(regName, () -> {
                    try {
                        return (Item)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        LOGGER.warn("There was an error registering " + regName);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == MobEffect.class) {
                MOB_EFFECTS.register(regName, () -> {
                    try {
                        return (MobEffect)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        LOGGER.warn("There was an error registering " + regName);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == RecipeSerializer.class) {
                SERIALIZERS.register(regName, () -> {
                    try {
                        return (RecipeSerializer)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        LOGGER.warn("There was an error registering " + regName);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == Attribute.class) {
                ATTRIBUTES.register(regName, () -> {
                    try {
                        return (Attribute)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        LOGGER.warn("There was an error registering " + regName);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == MenuType.class) {
                MENU_TYPE.register(regName, () -> {
                    try {
                        return (MenuType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        LOGGER.warn("There was an error registering " + regName);
                        return null;
                    }
                });
                continue;
            }
            throw new UnsupportedOperationException("No registry exists for the object \"" + reg.registry().getSimpleName() + ".class\".");
        }
        if (ModHandler.mods.get(mod.getModid()).eventBus() != null || FMLJavaModLoadingContext.get() != null) {
            IEventBus modEventBus = ModHandler.mods.get(mod.getModid()).eventBus() != null ? ModHandler.mods.get(mod.getModid()).eventBus() : FMLJavaModLoadingContext.get().getModEventBus();
            BLOCKS.register(modEventBus);
            FLUIDS.register(modEventBus);
            ITEMS.register(modEventBus);
            ENCHANTMENTS.register(modEventBus);
            MOB_EFFECTS.register(modEventBus);
            SERIALIZERS.register(modEventBus);
            ATTRIBUTES.register(modEventBus);
            MENU_TYPE.register(modEventBus);
        }
    }
}

