/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.hook.NeedleHooks;
import com.stereowalker.unionlib.util.NeedleUUIDs;
import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BowItem.class})
public abstract class BowItemMixin
extends ProjectileWeaponItem
implements Vanishable {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;

    public BowItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void dd(Item.Properties pProperties, CallbackInfo ci) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)UAttributes.DRAW_SPEED, (Object)new AttributeModifier(NeedleUUIDs.BASE_DRAW_SPEED_UUID, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @Redirect(method={"releaseUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/BowItem;getPowerForTime(I)F"))
    public float releaseUsing_redirect1(int charge, ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            return NeedleHooks.getBowPowerForTime(charge, player);
        }
        return BowItem.m_40661_((int)charge);
    }

    @Redirect(method={"releaseUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;shootFromRotation(Lnet/minecraft/world/entity/Entity;FFFFF)V"))
    public void releaseUsing_redirect2(AbstractArrow abstractarrow, Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        if (pShooter instanceof Player) {
            Player player = (Player)pShooter;
            float accuracy = 1.0f;
            float velocity = 1.0f;
            float damage = 0.0f;
            if (player.m_21051_(UAttributes.ACCURACY) != null) {
                accuracy = (float)player.m_21133_(UAttributes.ACCURACY);
            }
            if (player.m_21051_(UAttributes.ARROW_VELOCITY) != null) {
                velocity = (float)player.m_21133_(UAttributes.ARROW_VELOCITY);
            }
            if (player.m_21051_(UAttributes.ARROW_DAMAGE) != null) {
                damage = (float)player.m_21133_(UAttributes.ARROW_DAMAGE);
            }
            abstractarrow.m_37251_(pShooter, pX, pY, pZ, pVelocity * velocity, 2.0f - accuracy * 2.0f);
            abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)damage);
        } else {
            abstractarrow.m_37251_(pShooter, pX, pY, pZ, pVelocity, pInaccuracy);
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        if (UnionLib.Modules.isDefaultDrawSpeedAppliedToBows()) {
            return pEquipmentSlot.m_20743_() == EquipmentSlot.Type.HAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
        }
        return super.m_7167_(pEquipmentSlot);
    }
}

