/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ScreenHelper {
    public static int getYOffset(ScreenOffset pos, Minecraft mc) {
        if (pos.equals((Object)ScreenOffset.TOP_LEFT) || pos.equals((Object)ScreenOffset.TOP) || pos.equals((Object)ScreenOffset.TOP_RIGHT)) {
            return 0;
        }
        if (pos.equals((Object)ScreenOffset.LEFT) || pos.equals((Object)ScreenOffset.CENTER) || pos.equals((Object)ScreenOffset.RIGHT)) {
            return mc.m_91268_().m_85446_() / 2;
        }
        if (pos.equals((Object)ScreenOffset.BOTTOM_LEFT) || pos.equals((Object)ScreenOffset.BOTTOM) || pos.equals((Object)ScreenOffset.BOTTOM_RIGHT)) {
            return mc.m_91268_().m_85446_();
        }
        return 0;
    }

    public static int getXOffset(ScreenOffset pos, Minecraft mc) {
        if (pos.equals((Object)ScreenOffset.TOP_LEFT) || pos.equals((Object)ScreenOffset.LEFT) || pos.equals((Object)ScreenOffset.BOTTOM_LEFT)) {
            return 0;
        }
        if (pos.equals((Object)ScreenOffset.TOP) || pos.equals((Object)ScreenOffset.CENTER) || pos.equals((Object)ScreenOffset.BOTTOM)) {
            return mc.m_91268_().m_85446_() / 2;
        }
        if (pos.equals((Object)ScreenOffset.TOP_RIGHT) || pos.equals((Object)ScreenOffset.RIGHT) || pos.equals((Object)ScreenOffset.BOTTOM_RIGHT)) {
            return mc.m_91268_().m_85446_();
        }
        return 0;
    }

    public static void setWidgetPosition(AbstractWidget widget, int x, int y) {
        widget.f_93620_ = x;
        widget.f_93621_ = y;
    }

    public static void setWidgetY(AbstractWidget widget, int y) {
        widget.f_93621_ = y;
    }

    public static void setWidgetX(AbstractWidget widget, int x) {
        widget.f_93620_ = x;
    }

    public static int getWidgetY(AbstractWidget widget) {
        return widget.f_93621_;
    }

    public static int getWidgetX(AbstractWidget widget) {
        return widget.f_93620_;
    }

    public static Builder buttonBuilder(Component message, Button.OnPress onPress) {
        return new Builder(message, onPress);
    }

    public static enum ScreenOffset {
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        CENTER,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

    }

    public static class Builder {
        private final Component message;
        private final Button.OnPress onPress;
        @Nullable
        private Button.OnTooltip tooltip = Button.f_93716_;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;

        public Builder(Component component, Button.OnPress onPress) {
            this.message = component;
            this.onPress = onPress;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder tooltip(Button.OnTooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Button build() {
            Button button = new Button(this.x, this.y, this.width, this.height, this.message, this.onPress, this.tooltip);
            return button;
        }
    }
}

