/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.gson.AccessoryGroupDeserializer;
import com.stereowalker.tiered.gson.AccessorySlotDeserializer;
import com.stereowalker.tiered.gson.EntityAttributeModifierDeserializer;
import com.stereowalker.tiered.gson.EntityAttributeModifierSerializer;
import com.stereowalker.tiered.gson.EquipmentSlotDeserializer;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeDataLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(AttributeModifier.class, (Object)new EntityAttributeModifierDeserializer()).registerTypeAdapter(AttributeModifier.class, (Object)new EntityAttributeModifierSerializer()).registerTypeAdapter(EquipmentSlot.class, (Object)new EquipmentSlotDeserializer()).registerTypeAdapter(AccessorySlot.class, (Object)new AccessorySlotDeserializer()).registerTypeAdapter(AccessorySlot.Group.class, (Object)new AccessoryGroupDeserializer()).registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer()).create();
    private static final String PARSING_ERROR_MESSAGE = "Parsing error loading recipe {}";
    private static final String LOADED_RECIPES_MESSAGE = "Loaded {} item attributes";
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<ResourceLocation, PotentialAttribute> itemAttributes = new HashMap<ResourceLocation, PotentialAttribute>();

    public AttributeDataLoader() {
        super(GSON, "item_attributes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        HashMap readItemAttributes = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : loader.entrySet()) {
            ResourceLocation identifier = entry.getKey();
            try {
                PotentialAttribute itemAttribute = (PotentialAttribute)GSON.fromJson(entry.getValue(), PotentialAttribute.class);
                readItemAttributes.put(new ResourceLocation(itemAttribute.getID()), itemAttribute);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error(PARSING_ERROR_MESSAGE, (Object)identifier, (Object)exception);
            }
        }
        this.itemAttributes = readItemAttributes;
        LOGGER.info(LOADED_RECIPES_MESSAGE, (Object)readItemAttributes.size());
    }

    public Map<ResourceLocation, PotentialAttribute> getTiers() {
        return this.itemAttributes;
    }

    public void clear() {
        this.itemAttributes.clear();
    }

    public void replace(Map<ResourceLocation, PotentialAttribute> i) {
        this.itemAttributes = i;
    }
}

